/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network;

import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.network.c2s.ItemActionMessage;
import immersive_melodies.network.c2s.MelodyDeleteRequest;
import immersive_melodies.network.c2s.MelodyRequest;
import immersive_melodies.network.c2s.NoteBroadcastRequest;
import immersive_melodies.network.c2s.TrackToggleMessage;
import immersive_melodies.network.c2s.UploadMelodyRequest;
import immersive_melodies.network.s2c.MelodyListMessage;
import immersive_melodies.network.s2c.MelodyResponse;
import immersive_melodies.network.s2c.NoteMessage;
import immersive_melodies.network.s2c.OpenGuiRequest;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class Network {
    private static Sender sender;
    private static ClientSender clientSender;

    public static void registerSender(Sender sender) {
        Network.sender = sender;
    }

    public static void registerClientSender(ClientSender clientSender) {
        Network.clientSender = clientSender;
    }

    public static void sendToServer(ImmersivePayload payload) {
        clientSender.sendToServer(payload);
    }

    public static void sendToPlayer(ImmersivePayload payload, ServerPlayer player) {
        sender.sendToPlayer(payload, player);
    }

    public static void sendToAllPlayers(MinecraftServer server, ImmersivePayload payload) {
        server.m_6846_().m_11314_().forEach(p -> Network.sendToPlayer(payload, p));
    }

    public static void register(Registrar c) {
        c.register(ItemActionMessage.class, ItemActionMessage::new);
        c.register(MelodyDeleteRequest.class, MelodyDeleteRequest::new);
        c.register(MelodyRequest.class, MelodyRequest::new);
        c.register(NoteBroadcastRequest.class, NoteBroadcastRequest::new);
        c.register(TrackToggleMessage.class, TrackToggleMessage::new);
        c.register(UploadMelodyRequest.class, UploadMelodyRequest::new);
        c.register(MelodyListMessage.class, MelodyListMessage::new);
        c.register(MelodyResponse.class, MelodyResponse::new);
        c.register(NoteMessage.class, NoteMessage::new);
        c.register(OpenGuiRequest.class, OpenGuiRequest::new);
    }

    public static interface Sender {
        public void sendToPlayer(ImmersivePayload var1, ServerPlayer var2);
    }

    public static interface ClientSender {
        public void sendToServer(ImmersivePayload var1);
    }

    public static interface Registrar {
        public <T extends ImmersivePayload> void register(Class<T> var1, Function<FriendlyByteBuf, T> var2);
    }
}

