/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.chunkloading;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import rbasamoyai.ritchiesprojectilelib.config.RPLConfigs;

public class ChunkManager
extends SavedData {
    private final LongOpenHashSet chunks;
    private final LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
    private final LongOpenHashSet inQueue;
    private final Long2IntOpenHashMap loaded = new Long2IntOpenHashMap();

    public ChunkManager() {
        this(new LongOpenHashSet());
    }

    public ChunkManager(LongOpenHashSet chunks) {
        this.chunks = chunks;
        this.inQueue = new LongOpenHashSet((LongCollection)this.chunks);
        LongIterator longIterator = this.chunks.iterator();
        while (longIterator.hasNext()) {
            long packedPos = (Long)longIterator.next();
            this.queue.enqueue(packedPos);
        }
    }

    public static ChunkManager load(CompoundTag tag) {
        long[] arr = tag.m_128467_("LoadedChunks");
        LongOpenHashSet chunks = new LongOpenHashSet(arr);
        return new ChunkManager(chunks);
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128388_("LoadedChunks", this.chunks.toLongArray());
        return tag;
    }

    @Deprecated
    public void queueForceLoad(ChunkPos pos) {
        long packedPos = pos.m_45588_();
        if (this.inQueue.add(packedPos)) {
            this.queue.enqueue(packedPos);
            this.chunks.add(packedPos);
            this.m_77762_();
        }
    }

    public void tick(ServerLevel level) {
        long packedPos;
        LongSet vanillaForcedChunks = level.m_8902_();
        int MAX_SIZE = (Integer)RPLConfigs.server().maxChunksForceLoaded.get();
        if (MAX_SIZE <= 0) {
            MAX_SIZE = Integer.MAX_VALUE;
        }
        int MAX_CHUNKS_PROCESSED = (Integer)RPLConfigs.server().maxChunksLoadedEachTick.get();
        int DEFAULT_AGE = (Integer)RPLConfigs.server().projectileChunkAge.get();
        int ENTITY_LOAD_TIMEOUT_AGE = -((Integer)RPLConfigs.server().entityLoadTimeout.get()).intValue() - 1;
        LongOpenHashSet expired = new LongOpenHashSet();
        for (Map.Entry entry : this.loaded.long2IntEntrySet()) {
            long packedPos2 = (Long)entry.getKey();
            int age = (Integer)entry.getValue();
            if (age <= -1) {
                ChunkPos cpos = new ChunkPos(packedPos2);
                BlockPos bpos = new BlockPos(SectionPos.m_123223_((int)cpos.f_45578_), 0, SectionPos.m_123223_((int)cpos.f_45579_));
                if (level.m_143340_(bpos)) {
                    age = DEFAULT_AGE;
                }
            }
            int newAge = age - 1;
            entry.setValue(newAge);
            if (newAge != 0 && newAge > ENTITY_LOAD_TIMEOUT_AGE) continue;
            expired.add(packedPos2);
        }
        int freeSlots = Math.max(0, MAX_SIZE - this.loaded.size());
        int pollCount = Math.min(MAX_CHUNKS_PROCESSED, freeSlots + expired.size());
        pollCount = Math.min(pollCount, this.queue.size());
        for (int i = 0; i < pollCount && !this.queue.isEmpty(); ++i) {
            packedPos = this.queue.dequeueLong();
            this.inQueue.remove(packedPos);
            ChunkPos chunkPos = new ChunkPos(packedPos);
            if (this.loaded.containsKey(packedPos) && this.loaded.get(packedPos) > -1) {
                this.loaded.put(packedPos, DEFAULT_AGE);
                expired.remove(packedPos);
                continue;
            }
            if (!vanillaForcedChunks.contains(packedPos) && ChunkManager.loadChunkNoGenerate(level, chunkPos)) {
                this.loaded.put(packedPos, -1);
                level.m_7726_().m_6692_(chunkPos, true);
                continue;
            }
            this.chunks.remove(packedPos);
        }
        LongIterator longIterator = expired.iterator();
        while (longIterator.hasNext()) {
            packedPos = (Long)longIterator.next();
            level.m_7726_().m_6692_(new ChunkPos(packedPos), false);
            this.loaded.remove(packedPos);
            if (this.inQueue.contains(packedPos)) continue;
            this.chunks.remove(packedPos);
        }
        this.loaded.trim();
        this.inQueue.trim();
        this.queue.trim();
        this.chunks.trim();
        this.m_77762_();
    }

    private static boolean loadChunkNoGenerate(ServerLevel level, ChunkPos cpos) {
        ServerChunkCache source = level.m_7726_();
        LevelChunk immediate = source.m_7131_(cpos.f_45578_, cpos.f_45579_);
        if (immediate != null) {
            return true;
        }
        ChunkAccess access = source.m_7587_(cpos.f_45578_, cpos.f_45579_, ChunkStatus.f_62314_, true);
        if (access instanceof ProtoChunk) {
            source.m_8438_(TicketType.f_9449_, cpos, -11, (Object)cpos);
            access = source.m_7587_(cpos.f_45578_, cpos.f_45579_, ChunkStatus.f_62326_, true);
        }
        return access instanceof LevelChunk;
    }
}

