/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionHandler;
import com.simibubi.create.content.contraptions.sync.ContraptionInteractionPacket;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableObject;

@Mod.EventBusSubscriber
public class ContraptionHandlerClient {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void preventRemotePlayersWalkingAnimations(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof RemotePlayer)) {
            return;
        }
        RemotePlayer remotePlayer = (RemotePlayer)player;
        CompoundTag data = remotePlayer.getPersistentData();
        if (!data.m_128441_("LastOverrideLimbSwingUpdate")) {
            return;
        }
        int lastOverride = data.m_128451_("LastOverrideLimbSwingUpdate");
        data.m_128405_("LastOverrideLimbSwingUpdate", lastOverride + 1);
        if (lastOverride > 5) {
            data.m_128473_("LastOverrideLimbSwingUpdate");
            data.m_128473_("OverrideLimbSwing");
            return;
        }
        float limbSwing = data.m_128457_("OverrideLimbSwing");
        remotePlayer.f_19854_ = remotePlayer.m_20185_() - (double)(limbSwing / 4.0f);
        remotePlayer.f_19856_ = remotePlayer.m_20189_();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void rightClickingOnContraptionsGetsHandledLocally(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (mc.f_91073_ == null) {
            return;
        }
        if (!event.isUseItem()) {
            return;
        }
        Couple<Vec3> rayInputs = ContraptionHandlerClient.getRayInputs(player);
        Vec3 origin = (Vec3)rayInputs.getFirst();
        Vec3 target = (Vec3)rayInputs.getSecond();
        AABB aabb = new AABB(origin, target).m_82400_(16.0);
        Collection contraptions = ((Map)ContraptionHandler.loadedContraptions.get((LevelAccessor)mc.f_91073_)).values();
        double bestDistance = Double.MAX_VALUE;
        BlockHitResult bestResult = null;
        AbstractContraptionEntity bestEntity = null;
        for (WeakReference ref : contraptions) {
            double distance;
            BlockHitResult rayTraceResult;
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)ref.get());
            if (contraptionEntity == null || !contraptionEntity.m_20191_().m_82381_(aabb) || (rayTraceResult = ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity)) == null || (distance = contraptionEntity.toGlobalVector(rayTraceResult.m_82450_(), 1.0f).m_82554_(origin)) > bestDistance) continue;
            bestResult = rayTraceResult;
            bestDistance = distance;
            bestEntity = contraptionEntity;
        }
        if (bestResult == null) {
            return;
        }
        InteractionHand hand = event.getHand();
        Direction face = bestResult.m_82434_();
        BlockPos pos = bestResult.m_82425_();
        if (bestEntity.handlePlayerInteraction((Player)player, pos, face, hand)) {
            AllPackets.getChannel().sendToServer((Object)new ContraptionInteractionPacket(bestEntity, hand, pos, face));
        } else {
            ContraptionHandlerClient.handleSpecialInteractions(bestEntity, (Player)player, pos, face, hand);
        }
        event.setCanceled(true);
        event.setSwingHand(false);
    }

    private static boolean handleSpecialInteractions(AbstractContraptionEntity contraptionEntity, Player player, BlockPos localPos, Direction side, InteractionHand interactionHand) {
        if (AllItems.WRENCH.isIn(player.m_21120_(interactionHand)) && contraptionEntity instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity car = (CarriageContraptionEntity)contraptionEntity;
            return TrainRelocator.carriageWrenched(car.toGlobalVector(VecHelper.getCenterOf((Vec3i)localPos), 1.0f), car);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Couple<Vec3> getRayInputs(LocalPlayer player) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 origin = player.m_146892_();
        double reach = mc.f_91072_.m_105286_();
        if (mc.f_91077_ != null && mc.f_91077_.m_82450_() != null) {
            reach = Math.min(mc.f_91077_.m_82450_().m_82554_(origin), reach);
        }
        Vec3 target = RaycastHelper.getTraceTarget((Player)player, reach, origin);
        return Couple.create((Object)origin, (Object)target);
    }

    @Nullable
    public static BlockHitResult rayTraceContraption(Vec3 origin, Vec3 target, AbstractContraptionEntity contraptionEntity) {
        MutableObject mutableResult;
        Contraption contraption;
        Vec3 localTarget;
        Vec3 localOrigin = contraptionEntity.toLocalVector(origin, 1.0f);
        RaycastHelper.PredicateTraceResult predicateResult = RaycastHelper.rayTraceUntil(localOrigin, localTarget = contraptionEntity.toLocalVector(target, 1.0f), arg_0 -> ContraptionHandlerClient.lambda$rayTraceContraption$0(contraption = contraptionEntity.getContraption(), localOrigin, localTarget, mutableResult = new MutableObject(), arg_0));
        if (predicateResult == null || predicateResult.missed()) {
            return null;
        }
        BlockHitResult rayTraceResult = (BlockHitResult)mutableResult.getValue();
        return rayTraceResult;
    }

    private static /* synthetic */ boolean lambda$rayTraceContraption$0(Contraption contraption, Vec3 localOrigin, Vec3 localTarget, MutableObject mutableResult, BlockPos p) {
        for (Direction d : Iterate.directions) {
            BlockHitResult rayTrace;
            BlockState state;
            VoxelShape raytraceShape;
            if (d == Direction.UP) continue;
            BlockPos pos = d == Direction.DOWN ? p : p.m_121945_(d);
            StructureTemplate.StructureBlockInfo blockInfo = contraption.getBlocks().get(pos);
            if (blockInfo == null || (raytraceShape = (state = blockInfo.f_74676_()).m_60808_((BlockGetter)contraption.getContraptionWorld(), BlockPos.f_121853_.m_7495_())).m_83281_() || contraption.isHiddenInPortal(pos) || (rayTrace = raytraceShape.m_83220_(localOrigin, localTarget, pos)) == null) continue;
            mutableResult.setValue((Object)rayTrace);
            return true;
        }
        return false;
    }
}

