/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchableWithBracket;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockRotation;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class FluidPipeBlock
extends PipeBlock
implements SimpleWaterloggedBlock,
IWrenchableWithBracket,
IBE<FluidPipeBlockEntity>,
EncasableBlock,
TransformableBlock {
    private static final VoxelShape OCCLUSION_BOX = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public FluidPipeBlock(BlockBehaviour.Properties properties) {
        super(0.25f, properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        Direction.Axis axis = this.getAxis((BlockGetter)world, pos, state);
        if (axis == null) {
            Vec3 clickLocation = context.m_43720_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            double closest = 3.4028234663852886E38;
            Direction argClosest = Direction.UP;
            for (Direction direction : Iterate.directions) {
                Vec3 centerOf;
                double distance;
                if (clickedFace.m_122434_() == direction.m_122434_() || !((distance = (centerOf = Vec3.m_82512_((Vec3i)direction.m_122436_())).m_82557_(clickLocation)) < closest)) continue;
                closest = distance;
                argClosest = direction;
            }
            axis = argClosest.m_122434_();
        }
        if (clickedFace.m_122434_() == axis) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            this.withBlockEntityDo((BlockGetter)world, pos, fpte -> fpte.getBehaviour(FluidTransportBehaviour.TYPE).interfaces.values().stream().filter(pc -> pc != null && pc.hasFlow()).findAny().ifPresent($ -> AllAdvancements.GLASS_PIPE.awardTo(context.m_43723_())));
            FluidTransportBehaviour.cacheFlows((LevelAccessor)world, pos);
            world.m_46597_(pos, (BlockState)((BlockState)AllBlocks.GLASS_FLUID_PIPE.getDefaultState().m_61124_((Property)GlassFluidPipeBlock.f_55923_, (Comparable)axis)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_))));
            FluidTransportBehaviour.loadFlows((LevelAccessor)world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        InteractionResult result = this.tryEncase(state, world, pos, heldItem, player, hand, ray);
        if (result.m_19077_()) {
            return result;
        }
        return InteractionResult.PASS;
    }

    public BlockState getAxisState(Direction.Axis axis) {
        BlockState defaultState = this.m_49966_();
        for (Direction d : Iterate.directions) {
            defaultState = (BlockState)defaultState.m_61124_((Property)f_55154_.get(d), (Comparable)Boolean.valueOf(d.m_122434_() == axis));
        }
        return defaultState;
    }

    @Nullable
    private Direction.Axis getAxis(BlockGetter world, BlockPos pos, BlockState state) {
        return FluidPropagator.getStraightPipeAxis(state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.m_60734_() != newState.m_60734_();
        if (blockTypeChanged && !world.f_46443_) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
        }
        if (state != newState && !isMoving) {
            this.removeBracket((BlockGetter)world, pos, true).ifPresent(stack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack));
        }
        if (state.m_155947_() && (blockTypeChanged || !newState.m_155947_())) {
            world.m_46747_(pos);
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        if (state != oldState) {
            world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!FluidPipeBlock.isOpenAt(state, d)) {
            return;
        }
        world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource r) {
        FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
    }

    public static boolean isPipe(BlockState state) {
        return state.m_60734_() instanceof FluidPipeBlock;
    }

    public static boolean canConnectTo(BlockAndTintGetter world, BlockPos neighbourPos, BlockState neighbour, Direction direction) {
        if (FluidPropagator.hasFluidCapability((BlockGetter)world, neighbourPos, direction.m_122424_())) {
            return true;
        }
        if (VanillaFluidTargets.canProvideFluidWithoutCapability(neighbour)) {
            return true;
        }
        FluidTransportBehaviour transport = BlockEntityBehaviour.get((BlockGetter)world, neighbourPos, FluidTransportBehaviour.TYPE);
        BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get((BlockGetter)world, neighbourPos, BracketedBlockEntityBehaviour.TYPE);
        if (FluidPipeBlock.isPipe(neighbour)) {
            return bracket == null || !bracket.isBracketPresent() || FluidPropagator.getStraightPipeAxis(neighbour) == direction.m_122434_();
        }
        if (transport == null) {
            return false;
        }
        return transport.canHaveFlowToward(neighbour, direction.m_122424_());
    }

    public static boolean shouldDrawRim(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
        BlockPos offsetPos = pos.m_121945_(direction);
        BlockState facingState = world.m_8055_(offsetPos);
        if (facingState.m_60734_() instanceof EncasedPipeBlock) {
            return true;
        }
        if (!FluidPipeBlock.isPipe(facingState)) {
            return true;
        }
        return !FluidPipeBlock.canConnectTo(world, offsetPos, facingState, direction);
    }

    public static boolean isOpenAt(BlockState state, Direction direction) {
        return (Boolean)state.m_61143_((Property)f_55154_.get(direction));
    }

    public static boolean isCornerOrEndPipe(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        return FluidPipeBlock.isPipe(state) && FluidPropagator.getStraightPipeAxis(state) == null && !FluidPipeBlock.shouldDrawCasing(world, pos, state);
    }

    public static boolean shouldDrawCasing(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        if (!FluidPipeBlock.isPipe(state)) {
            return false;
        }
        for (Direction.Axis axis : Iterate.axes) {
            int connections = 0;
            for (Direction direction : Iterate.directions) {
                if (direction.m_122434_() == axis || !FluidPipeBlock.isOpenAt(state, direction)) continue;
                ++connections;
            }
            if (connections <= 2) continue;
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_55148_, f_55149_, f_55150_, f_55151_, f_55152_, f_55153_, BlockStateProperties.f_61362_});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState FluidState2 = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.updateBlockState(this.m_49966_(), context.m_7820_(), null, (BlockAndTintGetter)context.m_43725_(), context.m_8083_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (FluidPipeBlock.isOpenAt(state, direction) && neighbourState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
        }
        return this.updateBlockState(state, direction, direction.m_122424_(), (BlockAndTintGetter)world, pos);
    }

    public BlockState updateBlockState(BlockState state, Direction preferredDirection, @Nullable Direction ignore, BlockAndTintGetter world, BlockPos pos) {
        BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get((BlockGetter)world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent()) {
            return state;
        }
        BlockState prevState = state;
        int prevStateSides = (int)Arrays.stream(Iterate.directions).map(f_55154_::get).filter(arg_0 -> ((BlockState)prevState).m_61143_(arg_0)).count();
        for (Direction d : Iterate.directions) {
            if (d == ignore) continue;
            boolean shouldConnect = FluidPipeBlock.canConnectTo(world, pos.m_121945_(d), world.m_8055_(pos.m_121945_(d)), d);
            state = (BlockState)state.m_61124_((Property)f_55154_.get(d), (Comparable)Boolean.valueOf(shouldConnect));
        }
        Direction connectedDirection = null;
        for (Direction d : Iterate.directions) {
            if (!FluidPipeBlock.isOpenAt(state, d)) continue;
            if (connectedDirection != null) {
                return state;
            }
            connectedDirection = d;
        }
        if (connectedDirection != null) {
            return (BlockState)state.m_61124_((Property)f_55154_.get(connectedDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        if (prevStateSides == 2) {
            return prevState;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)f_55154_.get(preferredDirection), (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_55154_.get(preferredDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Override
    public Optional<ItemStack> removeBracket(BlockGetter world, BlockPos pos, boolean inOnReplacedContext) {
        BracketedBlockEntityBehaviour behaviour = BracketedBlockEntityBehaviour.get(world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null) {
            return Optional.empty();
        }
        BlockState bracket = behaviour.removeBracket(inOnReplacedContext);
        if (bracket == null) {
            return Optional.empty();
        }
        return Optional.of(new ItemStack((ItemLike)bracket.m_60734_()));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public Class<FluidPipeBlockEntity> getBlockEntityClass() {
        return FluidPipeBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.FLUID_PIPE.get();
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return false;
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return OCCLUSION_BOX;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return FluidPipeBlockRotation.rotate(pState, pRotation);
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return FluidPipeBlockRotation.mirror(pState, pMirror);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return FluidPipeBlockRotation.transform(state, transform);
    }
}

