/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.potion;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import java.util.Collection;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PotionFluid
extends VirtualFluid {
    public static PotionFluid createSource(ForgeFlowingFluid.Properties properties) {
        return new PotionFluid(properties, true);
    }

    public static PotionFluid createFlowing(ForgeFlowingFluid.Properties properties) {
        return new PotionFluid(properties, false);
    }

    public PotionFluid(ForgeFlowingFluid.Properties properties, boolean source) {
        super(properties, source);
    }

    public static FluidStack of(int amount, Potion potion, BottleType bottleType) {
        FluidStack fluidStack = new FluidStack(((PotionFluid)((Object)AllFluids.POTION.get())).m_5613_(), amount);
        PotionFluid.addPotionToFluidStack(fluidStack, potion);
        NBTHelper.writeEnum((CompoundTag)fluidStack.getOrCreateTag(), (String)"Bottle", (Enum)bottleType);
        return fluidStack;
    }

    public static FluidStack withEffects(int amount, Potion potion, List<MobEffectInstance> customEffects) {
        FluidStack fluidStack = PotionFluid.of(amount, potion, BottleType.REGULAR);
        PotionFluid.appendEffects(fluidStack, customEffects);
        return fluidStack;
    }

    public static FluidStack addPotionToFluidStack(FluidStack fs, Potion potion) {
        ResourceLocation resourcelocation = CatnipServices.REGISTRIES.getKeyOrThrow(potion);
        if (potion == Potions.f_43598_) {
            fs.removeChildTag("Potion");
            return fs;
        }
        fs.getOrCreateTag().m_128359_("Potion", resourcelocation.toString());
        return fs;
    }

    public static FluidStack appendEffects(FluidStack fs, Collection<MobEffectInstance> customEffects) {
        if (customEffects.isEmpty()) {
            return fs;
        }
        CompoundTag compoundnbt = fs.getOrCreateTag();
        ListTag listnbt = compoundnbt.m_128437_("CustomPotionEffects", 9);
        for (MobEffectInstance effectinstance : customEffects) {
            listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
        }
        compoundnbt.m_128365_("CustomPotionEffects", (Tag)listnbt);
        return fs;
    }

    public static enum BottleType {
        REGULAR,
        SPLASH,
        LINGERING;

    }

    public static class PotionFluidType
    extends AllFluids.TintedFluidType {
        public PotionFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        public int getTintColor(FluidStack stack) {
            CompoundTag tag = stack.getOrCreateTag();
            int color = PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag)) | 0xFF000000;
            return color;
        }

        public String getDescriptionId(FluidStack stack) {
            CompoundTag tag = stack.getOrCreateTag();
            ItemLike itemFromBottleType = PotionFluidHandler.itemFromBottleType((BottleType)NBTHelper.readEnum((CompoundTag)tag, (String)"Bottle", BottleType.class));
            return PotionUtils.m_43577_((CompoundTag)tag).m_43492_(itemFromBottleType.m_5456_().m_5524_() + ".effect.");
        }

        @Override
        protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return -1;
        }
    }
}

