/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.depot.EjectorPlacementPacket;
import com.simibubi.create.content.logistics.depot.EntityLauncher;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class EjectorTargetHandler {
    static BlockPos currentSelection;
    static ItemStack currentItem;
    static long lastHoveredBlockPos;
    static EntityLauncher launcher;

    @SubscribeEvent
    public static void rightClickingBlocksSelectsThem(PlayerInteractEvent.RightClickBlock event) {
        if (currentItem == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        if (!world.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        if (player == null || player.m_5833_() || !player.m_6144_()) {
            return;
        }
        String key = "weighted_ejector.target_set";
        ChatFormatting colour = ChatFormatting.GOLD;
        player.m_5661_((Component)CreateLang.translateDirect(key, new Object[0]).m_130940_(colour), true);
        currentSelection = pos;
        launcher = null;
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    @SubscribeEvent
    public static void leftClickingBlocksDeselectsThem(PlayerInteractEvent.LeftClickBlock event) {
        if (currentItem == null) {
            return;
        }
        if (!event.getLevel().f_46443_) {
            return;
        }
        if (!event.getEntity().m_6144_()) {
            return;
        }
        BlockPos pos = event.getPos();
        if (pos.equals((Object)currentSelection)) {
            currentSelection = null;
            launcher = null;
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static void flushSettings(BlockPos pos) {
        Direction validTargetDirection;
        int h = 0;
        int v = 0;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        String key = "weighted_ejector.target_not_valid";
        ChatFormatting colour = ChatFormatting.WHITE;
        if (currentSelection == null) {
            key = "weighted_ejector.no_target";
        }
        if ((validTargetDirection = EjectorTargetHandler.getValidTargetDirection(pos)) == null) {
            player.m_5661_((Component)CreateLang.translateDirect(key, new Object[0]).m_130940_(colour), true);
            currentItem = null;
            currentSelection = null;
            return;
        }
        key = "weighted_ejector.targeting";
        colour = ChatFormatting.GREEN;
        player.m_5661_((Component)CreateLang.translateDirect(key, currentSelection.m_123341_(), currentSelection.m_123342_(), currentSelection.m_123343_()).m_130940_(colour), true);
        BlockPos diff = pos.m_121996_((Vec3i)currentSelection);
        h = Math.abs(diff.m_123341_() + diff.m_123343_());
        v = -diff.m_123342_();
        AllPackets.getChannel().sendToServer((Object)new EjectorPlacementPacket(h, v, pos, validTargetDirection));
        currentSelection = null;
        currentItem = null;
    }

    public static Direction getValidTargetDirection(BlockPos pos) {
        if (currentSelection == null) {
            return null;
        }
        if (VecHelper.onSameAxis((BlockPos)pos, (BlockPos)currentSelection, (Direction.Axis)Direction.Axis.Y)) {
            return null;
        }
        int xDiff = currentSelection.m_123341_() - pos.m_123341_();
        int zDiff = currentSelection.m_123343_() - pos.m_123343_();
        int max = (Integer)AllConfigs.server().kinetics.maxEjectorDistance.get();
        if (Math.abs(xDiff) > max || Math.abs(zDiff) > max) {
            return null;
        }
        if (xDiff == 0) {
            return Direction.m_122390_((Direction.AxisDirection)(zDiff < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)Direction.Axis.Z);
        }
        if (zDiff == 0) {
            return Direction.m_122390_((Direction.AxisDirection)(xDiff < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)Direction.Axis.X);
        }
        return null;
    }

    public static void tick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.m_21205_();
        if (!AllBlocks.WEIGHTED_EJECTOR.isIn(heldItemMainhand)) {
            currentItem = null;
        } else {
            if (heldItemMainhand != currentItem) {
                currentSelection = null;
                currentItem = heldItemMainhand;
            }
            EjectorTargetHandler.drawOutline(currentSelection);
        }
        EjectorTargetHandler.checkForWrench(heldItemMainhand);
        EjectorTargetHandler.drawArc();
    }

    protected static void drawArc() {
        int validZ;
        Minecraft mc = Minecraft.m_91087_();
        boolean wrench = AllItems.WRENCH.isIn(mc.f_91074_.m_21205_());
        if (currentSelection == null) {
            return;
        }
        if (currentItem == null && !wrench) {
            return;
        }
        HitResult objectMouseOver = mc.f_91077_;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)objectMouseOver;
        if (blockRayTraceResult.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        BlockPos pos = blockRayTraceResult.m_82425_();
        if (!wrench) {
            pos = pos.m_121945_(blockRayTraceResult.m_82434_());
        }
        int xDiff = currentSelection.m_123341_() - pos.m_123341_();
        int yDiff = currentSelection.m_123342_() - pos.m_123342_();
        int zDiff = currentSelection.m_123343_() - pos.m_123343_();
        int validX = Math.abs(zDiff) > Math.abs(xDiff) ? 0 : xDiff;
        BlockPos validPos = currentSelection.m_7918_(validX, yDiff, validZ = Math.abs(zDiff) < Math.abs(xDiff) ? 0 : zDiff);
        Direction d = EjectorTargetHandler.getValidTargetDirection(validPos);
        if (d == null) {
            return;
        }
        if (launcher == null || lastHoveredBlockPos != pos.m_121878_()) {
            lastHoveredBlockPos = pos.m_121878_();
            launcher = new EntityLauncher(Math.abs(validX + validZ), yDiff);
        }
        double totalFlyingTicks = launcher.getTotalFlyingTicks() + 3.0;
        int segments = (int)totalFlyingTicks / 3 + 1;
        double tickOffset = totalFlyingTicks / (double)segments;
        boolean valid = xDiff == validX && zDiff == validZ;
        int intColor = valid ? 10411635 : 0xFF7171;
        Vector3f color = new Color(intColor).asVectorF();
        DustParticleOptions data = new DustParticleOptions(color, 1.0f);
        ClientLevel world = mc.f_91073_;
        AABB bb = new AABB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0).m_82338_(currentSelection.m_7918_(-validX, -yDiff, -validZ));
        Outliner.getInstance().chaseAABB((Object)"valid", bb).colored(intColor).lineWidth(0.0625f);
        for (int i = 0; i < segments; ++i) {
            double ticks = (double)(AnimationTickHolder.getRenderTime() / 3.0f) % tickOffset + (double)i * tickOffset;
            Vec3 vec = launcher.getGlobalPos(ticks, d, pos).m_82520_((double)(xDiff - validX), 0.0, (double)(zDiff - validZ));
            world.m_7106_((ParticleOptions)data, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private static void checkForWrench(ItemStack heldItem) {
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        HitResult objectMouseOver = Minecraft.m_91087_().f_91077_;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        BlockPos pos = result.m_82425_();
        BlockEntity be = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (!(be instanceof EjectorBlockEntity)) {
            lastHoveredBlockPos = -1L;
            currentSelection = null;
            return;
        }
        if (lastHoveredBlockPos == -1L || lastHoveredBlockPos != pos.m_121878_()) {
            EjectorBlockEntity ejector = (EjectorBlockEntity)be;
            if (!ejector.getTargetPosition().equals((Object)ejector.m_58899_())) {
                currentSelection = ejector.getTargetPosition();
            }
            lastHoveredBlockPos = pos.m_121878_();
            launcher = null;
        }
        if (lastHoveredBlockPos != -1L) {
            EjectorTargetHandler.drawOutline(currentSelection);
        }
    }

    public static void drawOutline(BlockPos selection) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (selection == null) {
            return;
        }
        BlockPos pos = selection;
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)world, pos);
        AABB boundingBox = shape.m_83281_() ? new AABB(BlockPos.f_121853_) : shape.m_83215_();
        Outliner.getInstance().showAABB((Object)"target", boundingBox.m_82338_(pos)).colored(16763764).lineWidth(0.0625f);
    }

    static {
        lastHoveredBlockPos = -1L;
    }
}

