/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.tableCloth;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.redstoneRequester.AutoRequestData;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.ShopUpdatePacket;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlock;
import com.simibubi.create.content.logistics.tableCloth.TableClothFilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.RemoveBlockEntityPacket;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class TableClothBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public AbstractComputerBehaviour computerBehaviour;
    public AutoRequestData requestData;
    public List<ItemStack> manuallyAddedItems = new ArrayList<ItemStack>();
    public UUID owner = null;
    public Direction facing;
    public boolean sideOccluded;
    public FilteringBehaviour priceTag;
    private List<ItemStack> renderedItemsForShop;

    public TableClothBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.requestData = new AutoRequestData();
        this.facing = Direction.SOUTH;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.priceTag = new TableClothFilteringBehaviour(this);
        behaviours.add(this.priceTag);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public List<ItemStack> getItemsForRender() {
        if (this.isShop()) {
            if (this.renderedItemsForShop == null) {
                this.renderedItemsForShop = this.requestData.encodedRequest.stacks().stream().map(b -> b.stack).limit(4L).toList();
            }
            return this.renderedItemsForShop;
        }
        return this.manuallyAddedItems;
    }

    public void invalidateItemsForRender() {
        this.renderedItemsForShop = null;
    }

    public void notifyShopUpdate() {
        AllPackets.getChannel().send(this.packetTarget(), (Object)new ShopUpdatePacket(this.f_58858_));
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        BlockPos relativePos = this.f_58858_.m_121945_(this.facing);
        this.sideOccluded = AllTags.AllBlockTags.TABLE_CLOTHS.matches(this.f_58857_.m_8055_(relativePos)) || Block.m_49918_((VoxelShape)this.f_58857_.m_8055_(relativePos.m_7495_()).m_60768_((BlockGetter)this.f_58857_, relativePos.m_7495_()), (Direction)this.facing.m_122424_());
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(1.0);
    }

    public boolean isShop() {
        return !this.requestData.encodedRequest.isEmpty();
    }

    public InteractionResult use(Player player, BlockHitResult ray) {
        if (this.isShop()) {
            return this.useShop(player);
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            if (this.manuallyAddedItems.isEmpty()) {
                return InteractionResult.SUCCESS;
            }
            player.m_21008_(InteractionHand.MAIN_HAND, this.manuallyAddedItems.remove(this.manuallyAddedItems.size() - 1));
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (this.manuallyAddedItems.isEmpty() && !this.computerBehaviour.hasAttachedComputer()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TableClothBlock.HAS_BE, (Comparable)Boolean.valueOf(false)), 3);
                AllPackets.getChannel().send(this.packetTarget(), (Object)new RemoveBlockEntityPacket(this.f_58858_));
            } else {
                this.notifyUpdate();
            }
            return InteractionResult.SUCCESS;
        }
        if (this.manuallyAddedItems.size() >= 4) {
            return InteractionResult.SUCCESS;
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.manuallyAddedItems.add(heldItem.m_255036_(1));
        this.facing = player.m_6350_().m_122424_();
        heldItem.m_41774_(1);
        if (heldItem.m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        this.notifyUpdate();
        return InteractionResult.SUCCESS;
    }

    public boolean targetsPriceTag(Player player, BlockHitResult ray) {
        return this.priceTag != null && this.priceTag.mayInteract(player) && this.priceTag.getSlotPositioning().testHit((LevelAccessor)this.f_58857_, this.f_58858_, this.m_58900_(), ray.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)this.f_58858_)));
    }

    public InteractionResult useShop(Player player) {
        StockTickerBlockEntity stbe;
        ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack prevListItem = ItemStack.f_41583_;
        boolean addOntoList = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack item = player.m_150109_().m_8020_(i);
            if (!AllItems.SHOPPING_LIST.isIn(item)) continue;
            prevListItem = item;
            addOntoList = true;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
        }
        if (AllItems.SHOPPING_LIST.isIn(itemInHand)) {
            prevListItem = itemInHand;
            addOntoList = true;
        }
        if (!itemInHand.m_41619_() && !addOntoList) {
            CreateLang.translate("stock_keeper.shopping_list_empty_hand", new Object[0]).sendStatus(player);
            AllSoundEvents.DENY.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.getPaymentItem().m_41619_()) {
            CreateLang.translate("stock_keeper.no_price_set", new Object[0]).sendStatus(player);
            AllSoundEvents.DENY.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        UUID tickerID = null;
        BlockPos tickerPos = this.requestData.targetOffset.m_121955_((Vec3i)this.f_58858_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(tickerPos);
        if (blockEntity instanceof StockTickerBlockEntity && (stbe = (StockTickerBlockEntity)blockEntity).isKeeperPresent()) {
            tickerID = stbe.behaviour.freqId;
        }
        int stockLevel = this.getStockLevelForTrade(ShoppingListItem.getList(prevListItem));
        if (tickerID == null) {
            CreateLang.translate("stock_keeper.keeper_missing", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            AllSoundEvents.DENY.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (stockLevel == 0) {
            CreateLang.translate("stock_keeper.out_of_stock", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            AllSoundEvents.DENY.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.5f, 1.0f);
            if (!prevListItem.m_41619_()) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, prevListItem);
                } else {
                    player.m_150109_().m_150079_(prevListItem);
                }
            }
            return InteractionResult.SUCCESS;
        }
        Object list = new ShoppingListItem.ShoppingList(new ArrayList<IntAttached<BlockPos>>(), this.owner, tickerID);
        if (addOntoList) {
            ShoppingListItem.ShoppingList prevList = ShoppingListItem.getList(prevListItem);
            if (this.owner.equals(prevList.shopOwner()) && tickerID.equals(prevList.shopNetwork())) {
                list = prevList;
            } else {
                addOntoList = false;
            }
        }
        if (((ShoppingListItem.ShoppingList)list).getPurchases(this.f_58858_) >= stockLevel) {
            for (IntAttached intAttached : ((ShoppingListItem.ShoppingList)list).purchases()) {
                if (!this.f_58858_.equals(intAttached.getValue())) continue;
                intAttached.setFirst((Object)Math.min(stockLevel, (Integer)intAttached.getFirst()));
            }
            CreateLang.translate("stock_keeper.limited_stock", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
        } else {
            AllSoundEvents.CONFIRM_2.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.5f, 1.0f);
            ((ShoppingListItem.ShoppingList)list).addPurchases(this.f_58858_, 1);
            if (!addOntoList) {
                CreateLang.translate("stock_keeper.use_list_to_add_purchases", new Object[0]).color(0xEEEEEE).sendStatus(player);
            }
            if (!addOntoList) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, 1.5f);
            }
        }
        ItemStack newListItem = ShoppingListItem.saveList(AllItems.SHOPPING_LIST.asStack(), (ShoppingListItem.ShoppingList)list, this.requestData.encodedTargetAdress);
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, newListItem);
        } else {
            player.m_150109_().m_150079_(newListItem);
        }
        return InteractionResult.SUCCESS;
    }

    public int getStockLevelForTrade(@Nullable ShoppingListItem.ShoppingList otherPurchases) {
        BlockPos tickerPos = this.requestData.targetOffset.m_121955_((Vec3i)this.f_58858_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(tickerPos);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            return 0;
        }
        StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
        InventorySummary recentSummary = null;
        if (this.f_58857_.m_5776_()) {
            if (stbe.getTicksSinceLastUpdate() > 15) {
                stbe.refreshClientStockSnapshot();
            }
            recentSummary = stbe.getLastClientsideStockSnapshotAsSummary();
        } else {
            recentSummary = stbe.getRecentSummary();
        }
        if (recentSummary == null) {
            return 0;
        }
        InventorySummary modifierSummary = new InventorySummary();
        if (otherPurchases != null) {
            modifierSummary = (InventorySummary)otherPurchases.bakeEntries((LevelAccessor)this.f_58857_, this.f_58858_).getFirst();
        }
        int smallestQuotient = Integer.MAX_VALUE;
        for (BigItemStack entry : this.requestData.encodedRequest.stacks()) {
            if (entry.count <= 0) continue;
            smallestQuotient = Math.min(smallestQuotient, (recentSummary.getCountOf(entry.stack) - modifierSummary.getCountOf(entry.stack)) / entry.count);
        }
        return smallestQuotient;
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("Items", (Tag)NBTHelper.writeItemList(this.manuallyAddedItems));
        tag.m_128405_("Facing", this.facing.m_122416_());
        this.requestData.write(tag);
        if (this.owner != null) {
            tag.m_128362_("OwnerUUID", this.owner);
        }
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.manuallyAddedItems = NBTHelper.readItemList((ListTag)tag.m_128437_("Items", 10));
        this.requestData = AutoRequestData.read(tag);
        this.owner = tag.m_128441_("OwnerUUID") ? tag.m_128342_("OwnerUUID") : null;
        this.facing = Direction.m_122407_((int)Mth.m_14100_((int)tag.m_128451_("Facing"), (int)4));
    }

    @Override
    public void destroy() {
        super.destroy();
        this.manuallyAddedItems.forEach(stack -> Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack));
        this.manuallyAddedItems.clear();
    }

    public ItemStack getPaymentItem() {
        return this.priceTag.getFilter();
    }

    public int getPaymentAmount() {
        return this.priceTag.getFilter().m_41619_() ? 1 : this.priceTag.count;
    }

    @Override
    public void transform(BlockEntity blockEntity, StructureTransform transform) {
        this.facing = transform.mirrorFacing(this.facing);
        if (transform.rotationAxis == Direction.Axis.Y) {
            this.facing = transform.rotateFacing(this.facing);
        }
        this.notifyUpdate();
    }
}

