/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.decoration.slidingDoor.DoorControl;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.AbstractStationScreen;
import com.simibubi.create.content.trains.station.AssemblyScreen;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationEditPacket;
import com.simibubi.create.content.trains.station.TrainEditPacket;
import com.simibubi.create.content.trains.station.WideIconButton;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.gui.UIRenderHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class StationScreen
extends AbstractStationScreen {
    private EditBox nameBox;
    private EditBox trainNameBox;
    private IconButton newTrainButton;
    private IconButton disassembleTrainButton;
    private IconButton dropScheduleButton;
    private int leavingAnimation;
    private LerpedFloat trainPosition;
    private DoorControl doorControl;
    private ScrollInput colorTypeScroll;
    private int messedWithColors;
    private boolean switchingToAssemblyMode;

    public StationScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        this.background = AllGuiTextures.STATION;
        this.leavingAnimation = 0;
        this.trainPosition = LerpedFloat.linear().startWithValue(0.0);
        this.switchingToAssemblyMode = false;
        this.doorControl = be.doorControls.mode;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        Consumer<String> onTextChanged = s -> this.nameBox.m_252865_(this.nameBoxX((String)s, this.nameBox));
        this.nameBox = new EditBox((Font)new NoShadowFontWrapper(this.f_96547_), x + 23, y + 4, this.background.getWidth() - 20, 10, (Component)Component.m_237113_((String)this.station.name));
        this.nameBox.m_94182_(false);
        this.nameBox.m_94199_(25);
        this.nameBox.m_94202_(5841956);
        this.nameBox.m_94144_(this.station.name);
        this.nameBox.m_93692_(false);
        this.nameBox.m_6375_(0.0, 0.0, 0);
        this.nameBox.m_94151_(onTextChanged);
        this.nameBox.m_252865_(this.nameBoxX(this.nameBox.m_94155_(), this.nameBox));
        this.m_142416_((GuiEventListener)this.nameBox);
        Runnable assemblyCallback = () -> {
            this.switchingToAssemblyMode = true;
            this.f_96541_.m_91152_((Screen)new AssemblyScreen(this.blockEntity, this.station));
        };
        this.newTrainButton = new WideIconButton(x + 84, y + 65, AllGuiTextures.I_NEW_TRAIN);
        this.newTrainButton.withCallback(assemblyCallback);
        this.m_142416_((GuiEventListener)this.newTrainButton);
        this.disassembleTrainButton = new WideIconButton(x + 94, y + 65, AllGuiTextures.I_DISASSEMBLE_TRAIN);
        this.disassembleTrainButton.f_93623_ = false;
        this.disassembleTrainButton.f_93624_ = false;
        this.disassembleTrainButton.withCallback(assemblyCallback);
        this.m_142416_((GuiEventListener)this.disassembleTrainButton);
        this.dropScheduleButton = new IconButton(x + 73, y + 65, AllIcons.I_VIEW_SCHEDULE);
        this.dropScheduleButton.f_93623_ = false;
        this.dropScheduleButton.f_93624_ = false;
        this.dropScheduleButton.withCallback(() -> AllPackets.getChannel().sendToServer((Object)StationEditPacket.dropSchedule(this.blockEntity.m_58899_())));
        this.m_142416_((GuiEventListener)this.dropScheduleButton);
        this.colorTypeScroll = new ScrollInput(x + 166, y + 17, 22, 14).titled(CreateLang.translateDirect("station.train_map_color", new Object[0]));
        this.colorTypeScroll.withRange(0, 16);
        this.colorTypeScroll.withStepFunction(ctx -> this.colorTypeScroll.standardStep().apply((ScrollValueBehaviour.StepContext)ctx));
        this.colorTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.mapColorIndex = s;
                this.messedWithColors = 10;
            }
        });
        this.colorTypeScroll.f_93624_ = false;
        this.colorTypeScroll.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.colorTypeScroll);
        onTextChanged = s -> this.trainNameBox.m_252865_(this.nameBoxX((String)s, this.trainNameBox));
        this.trainNameBox = new EditBox(this.f_96547_, x + 23, y + 47, this.background.getWidth() - 75, 10, CommonComponents.f_237098_);
        this.trainNameBox.m_94182_(false);
        this.trainNameBox.m_94199_(35);
        this.trainNameBox.m_94202_(0xC6C6C6);
        this.trainNameBox.m_93692_(false);
        this.trainNameBox.m_6375_(0.0, 0.0, 0);
        this.trainNameBox.m_94151_(onTextChanged);
        this.trainNameBox.f_93623_ = false;
        this.tickTrainDisplay();
        Pair<ScrollInput, Label> doorControlWidgets = DoorControl.createWidget(x + 35, y + 102, mode -> {
            this.doorControl = mode;
        }, this.doorControl);
        this.m_142416_((GuiEventListener)((ScrollInput)((Object)doorControlWidgets.getFirst())));
        this.m_142416_((GuiEventListener)((Label)((Object)doorControlWidgets.getSecond())));
    }

    @Override
    public void m_86600_() {
        this.tickTrainDisplay();
        if (this.m_7222_() != this.nameBox) {
            this.nameBox.m_94196_(this.nameBox.m_94155_().length());
            this.nameBox.m_94208_(this.nameBox.m_94207_());
        }
        if (this.m_7222_() != this.trainNameBox || !this.trainNameBox.f_93623_) {
            this.trainNameBox.m_94196_(this.trainNameBox.m_94155_().length());
            this.trainNameBox.m_94208_(this.trainNameBox.m_94207_());
        }
        if (this.messedWithColors > 0) {
            --this.messedWithColors;
            if (this.messedWithColors == 0) {
                this.syncTrainNameAndColor();
            }
        }
        super.m_86600_();
        this.updateAssemblyTooltip(this.blockEntity.edgePoint.isOnCurve() ? "no_assembly_curve" : (!this.blockEntity.edgePoint.isOrthogonal() ? "no_assembly_diagonal" : (this.trainPresent() && !this.blockEntity.trainCanDisassemble ? "train_not_aligned" : null)));
    }

    private void tickTrainDisplay() {
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            if (this.trainNameBox.f_93623_) {
                this.trainNameBox.f_93623_ = false;
                this.m_169411_((GuiEventListener)this.trainNameBox);
            }
            this.leavingAnimation = 0;
            this.newTrainButton.f_93623_ = this.blockEntity.edgePoint.isOrthogonal();
            this.newTrainButton.f_93624_ = true;
            this.colorTypeScroll.f_93624_ = false;
            this.colorTypeScroll.f_93623_ = false;
            Train imminentTrain = this.getImminent();
            if (imminentTrain != null) {
                this.displayedTrain = new WeakReference<Train>(imminentTrain);
                this.newTrainButton.f_93623_ = false;
                this.newTrainButton.f_93624_ = false;
                this.disassembleTrainButton.f_93623_ = false;
                this.disassembleTrainButton.f_93624_ = true;
                this.dropScheduleButton.f_93623_ = this.blockEntity.trainHasSchedule;
                this.dropScheduleButton.f_93624_ = true;
                if (this.mapModsPresent()) {
                    this.colorTypeScroll.setState(imminentTrain.mapColorIndex);
                    this.colorTypeScroll.f_93624_ = true;
                    this.colorTypeScroll.f_93623_ = true;
                }
                this.trainNameBox.f_93623_ = true;
                this.trainNameBox.m_94144_(imminentTrain.name.getString());
                this.trainNameBox.m_252865_(this.nameBoxX(this.trainNameBox.m_94155_(), this.trainNameBox));
                this.m_142416_((GuiEventListener)this.trainNameBox);
                int trainIconWidth = this.getTrainIconWidth(imminentTrain);
                int targetPos = this.background.getWidth() / 2 - trainIconWidth / 2;
                if (trainIconWidth > 130) {
                    targetPos -= trainIconWidth - 130;
                }
                float f = (float)(imminentTrain.navigation.distanceToDestination / 15.0);
                if (this.trainPresent()) {
                    f = 0.0f;
                }
                this.trainPosition.startWithValue((double)((float)targetPos - (float)(targetPos + 5) * f));
            }
            return;
        }
        int trainIconWidth = this.getTrainIconWidth(train);
        int targetPos = this.background.getWidth() / 2 - trainIconWidth / 2;
        if (trainIconWidth > 130) {
            targetPos -= trainIconWidth - 130;
        }
        if (this.leavingAnimation > 0) {
            this.colorTypeScroll.f_93624_ = false;
            this.colorTypeScroll.f_93623_ = false;
            this.disassembleTrainButton.f_93623_ = false;
            float f = 1.0f - (float)this.leavingAnimation / 80.0f;
            this.trainPosition.setValue((double)((float)targetPos + f * f * f * (float)(this.background.getWidth() - targetPos + 5)));
            --this.leavingAnimation;
            if (this.leavingAnimation > 0) {
                return;
            }
            this.displayedTrain = new WeakReference<Object>(null);
            this.disassembleTrainButton.f_93624_ = false;
            this.dropScheduleButton.f_93623_ = false;
            this.dropScheduleButton.f_93624_ = false;
            return;
        }
        if (this.getImminent() != train) {
            this.leavingAnimation = 80;
            return;
        }
        boolean trainAtStation = this.trainPresent();
        this.disassembleTrainButton.f_93623_ = trainAtStation && this.blockEntity.trainCanDisassemble && this.blockEntity.edgePoint.isOrthogonal();
        this.dropScheduleButton.f_93623_ = this.blockEntity.trainHasSchedule;
        if (this.blockEntity.trainHasSchedule) {
            this.dropScheduleButton.setToolTip((Component)CreateLang.translateDirect(this.blockEntity.trainHasAutoSchedule ? "station.remove_auto_schedule" : "station.remove_schedule", new Object[0]));
        } else {
            this.dropScheduleButton.getToolTip().clear();
        }
        float f = trainAtStation ? 0.0f : (float)(train.navigation.distanceToDestination / 30.0);
        this.trainPosition.setValue((double)((float)targetPos - (float)(targetPos + trainIconWidth) * f));
    }

    private int nameBoxX(String s, EditBox nameBox) {
        return this.guiLeft + this.background.getWidth() / 2 - (Math.min(this.f_96547_.m_92895_(s), nameBox.m_5711_()) + 10) / 2;
    }

    private void updateAssemblyTooltip(String key) {
        if (key == null) {
            this.disassembleTrainButton.setToolTip((Component)CreateLang.translateDirect("station.disassemble_train", new Object[0]));
            this.newTrainButton.setToolTip((Component)CreateLang.translateDirect("station.create_train", new Object[0]));
            return;
        }
        for (IconButton ib : new IconButton[]{this.disassembleTrainButton, this.newTrainButton}) {
            List toolTip = ib.getToolTip();
            toolTip.clear();
            toolTip.add(CreateLang.translateDirect("station." + key, new Object[0]).m_130940_(ChatFormatting.GRAY));
            toolTip.add(CreateLang.translateDirect("station." + key + "_1", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        String text = this.nameBox.m_94155_();
        if (!this.nameBox.m_93696_()) {
            AllGuiTextures.STATION_EDIT_NAME.render(graphics, this.nameBoxX(text, this.nameBox) + this.f_96547_.m_92895_(text) + 5, y + 1);
        }
        graphics.m_280480_(AllBlocks.TRAIN_DOOR.asStack(), x + 14, y + 103);
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            MutableComponent header = CreateLang.translateDirect("station.idle", new Object[0]);
            graphics.m_280614_(this.f_96547_, (Component)header, x + 97 - this.f_96547_.m_92852_((FormattedText)header) / 2, y + 47, 0x7A7A7A, false);
            return;
        }
        float position = this.trainPosition.getValue(partialTicks);
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        RenderSystem.enableBlend();
        ms.m_252880_(position, 0.0f, 0.0f);
        TrainIconType icon = train.icon;
        int offset = 0;
        List<Carriage> carriages = train.carriages;
        for (int i = carriages.size() - 1; i > 0; --i) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, Math.min((position + (float)offset - 10.0f) / 30.0f, ((float)(this.background.getWidth() - 40) - position - (float)offset) / 30.0f)));
            Carriage carriage = carriages.get(this.blockEntity.trainBackwards ? carriages.size() - i - 1 : i);
            offset += icon.render(carriage.bogeySpacing, graphics, x + offset, y + 20) + 1;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, Math.min((position + (float)offset - 10.0f) / 30.0f, ((float)(this.background.getWidth() - 40) - position - (float)offset) / 30.0f)));
        offset += icon.render(-1, graphics, x + offset, y + 20);
        RenderSystem.disableBlend();
        ms.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AllGuiTextures.STATION_TEXTBOX_TOP.render(graphics, x + 21, y + 42);
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)(x + 21), (int)(y + 60), (int)150, (int)26, (int)0, (TextureSheetSegment)AllGuiTextures.STATION_TEXTBOX_MIDDLE);
        AllGuiTextures.STATION_TEXTBOX_BOTTOM.render(graphics, x + 21, y + 86);
        ms.m_85836_();
        ms.m_252880_(Mth.m_14036_((float)(position + (float)offset - 13.0f), (float)25.0f, (float)159.0f), 0.0f, 0.0f);
        AllGuiTextures.STATION_TEXTBOX_SPEECH.render(graphics, x, y + 38);
        ms.m_85849_();
        text = this.trainNameBox.m_94155_();
        if (!this.trainNameBox.m_93696_()) {
            int buttonX = this.nameBoxX(text, this.trainNameBox) + this.f_96547_.m_92895_(text) + 5;
            AllGuiTextures.STATION_EDIT_TRAIN_NAME.render(graphics, Math.min(buttonX, this.guiLeft + 156), y + 44);
            if (this.f_96547_.m_92895_(text) > this.trainNameBox.m_5711_()) {
                graphics.m_280488_(this.f_96547_, "...", this.guiLeft + 26, this.guiTop + 47, 0xA6A6A6);
            }
        }
        if (!this.mapModsPresent()) {
            return;
        }
        AllGuiTextures sprite = AllGuiTextures.TRAINMAP_SPRITES;
        sprite.bind();
        int trainColorIndex = this.colorTypeScroll.getState();
        int colorRow = trainColorIndex / 4;
        int colorCol = trainColorIndex % 4;
        int rotation = AnimationTickHolder.getTicks() / 5 % 8;
        for (int slice = 0; slice < 3; ++slice) {
            int row = slice == 0 ? 1 : (slice == 2 ? 2 : 3);
            int col = rotation;
            int positionX = this.colorTypeScroll.m_252754_() + 4;
            int positionY = this.colorTypeScroll.m_252907_() - 1;
            int sheetX = col * 16 + colorCol * 128;
            int sheetY = row * 16 + colorRow * 64;
            graphics.m_280163_(sprite.location, positionX, positionY, (float)sheetX, (float)sheetY, 16, 16, sprite.getWidth(), sprite.getHeight());
        }
    }

    public boolean mapModsPresent() {
        return Mods.FTBCHUNKS.isLoaded() || Mods.JOURNEYMAP.isLoaded() || Mods.XAEROWORLDMAP.isLoaded();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.nameBox.m_93696_() && pMouseY > (double)this.guiTop && pMouseY < (double)(this.guiTop + 14) && pMouseX > (double)this.guiLeft && pMouseX < (double)(this.guiLeft + this.background.getWidth())) {
            this.nameBox.m_93692_(true);
            this.nameBox.m_94208_(0);
            this.m_7522_((GuiEventListener)this.nameBox);
            return true;
        }
        if (this.trainNameBox.f_93623_ && !this.trainNameBox.m_93696_() && pMouseY > (double)(this.guiTop + 45) && pMouseY < (double)(this.guiTop + 58) && pMouseX > (double)(this.guiLeft + 25) && pMouseX < (double)(this.guiLeft + 168)) {
            this.trainNameBox.m_93692_(true);
            this.trainNameBox.m_94208_(0);
            this.m_7522_((GuiEventListener)this.trainNameBox);
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitEnter;
        boolean bl = hitEnter = this.m_7222_() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.nameBox.m_93696_()) {
            this.nameBox.m_93692_(false);
            this.syncStationName();
            return true;
        }
        if (hitEnter && this.trainNameBox.m_93696_()) {
            this.trainNameBox.m_93692_(false);
            this.syncTrainNameAndColor();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private void syncTrainNameAndColor() {
        Train train = (Train)this.displayedTrain.get();
        if (train != null && !this.trainNameBox.m_94155_().equals(train.name.getString())) {
            AllPackets.getChannel().sendToServer((Object)new TrainEditPacket(train.id, this.trainNameBox.m_94155_(), train.icon.getId(), train.mapColorIndex));
        }
    }

    private void syncStationName() {
        if (!this.nameBox.m_94155_().equals(this.station.name)) {
            AllPackets.getChannel().sendToServer((Object)StationEditPacket.configure(this.blockEntity.m_58899_(), false, this.nameBox.m_94155_(), this.doorControl));
        }
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.nameBox == null || this.trainNameBox == null) {
            return;
        }
        AllPackets.getChannel().sendToServer((Object)StationEditPacket.configure(this.blockEntity.m_58899_(), this.switchingToAssemblyMode, this.nameBox.m_94155_(), this.doorControl));
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            return;
        }
        if (!this.switchingToAssemblyMode) {
            AllPackets.getChannel().sendToServer((Object)new TrainEditPacket(train.id, this.trainNameBox.m_94155_(), train.icon.getId(), train.mapColorIndex));
        } else {
            this.blockEntity.imminentTrain = null;
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return this.blockEntity.flag.getValue(partialTicks) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF;
    }
}

