/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.impl.contraption.dispenser;

import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.MountedProjectileDispenseBehavior;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.behaviour.dispenser.ContraptionBlockSource;
import com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public enum DispenserBehaviorConverter implements SimpleRegistry.Provider<Item, MountedDispenseBehavior>
{
    INSTANCE;


    @Override
    @Nullable
    public MountedDispenseBehavior get(Item item) {
        DispenseItemBehavior vanilla = DispenserBehaviorConverter.getDispenseMethod(new ItemStack((ItemLike)item));
        if (vanilla == null) {
            return null;
        }
        if (vanilla.getClass() == DefaultDispenseItemBehavior.class) {
            return null;
        }
        if (AllTags.AllItemTags.DISPENSE_BEHAVIOR_WRAP_BLACKLIST.matches(item)) {
            return null;
        }
        if (vanilla instanceof AbstractProjectileDispenseBehavior) {
            AbstractProjectileDispenseBehavior projectile = (AbstractProjectileDispenseBehavior)vanilla;
            return MountedProjectileDispenseBehavior.of(projectile);
        }
        return new FallbackBehavior(item, vanilla);
    }

    @Override
    public void onRegister(Runnable invalidate) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.shouldUpdateStaticData()) {
                invalidate.run();
            }
        });
    }

    @Nullable
    private static DispenseItemBehavior getDispenseMethod(ItemStack stack) {
        return ((DispenserBlockAccessor)Blocks.f_50061_).create$callGetDispenseMethod(stack);
    }

    private static final class FallbackBehavior
    extends DefaultMountedDispenseBehavior {
        private final Item item;
        private final DispenseItemBehavior wrapped;
        private boolean hasErrored;

        private FallbackBehavior(Item item, DispenseItemBehavior wrapped) {
            this.item = item;
            this.wrapped = wrapped;
        }

        @Override
        protected ItemStack execute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
            if (this.hasErrored) {
                return stack;
            }
            Direction nearestFacing = MountedDispenseBehavior.getClosestFacingDirection(facing);
            ContraptionBlockSource source = new ContraptionBlockSource(context, pos, nearestFacing);
            try {
                return this.wrapped.m_6115_((BlockSource)source, stack.m_41777_());
            }
            catch (NullPointerException e) {
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)this.item);
                String message = "Error dispensing item '" + String.valueOf(itemId) + "' from contraption, not doing that anymore";
                Create.LOGGER.error(message, (Throwable)e);
                this.hasErrored = true;
                return stack;
            }
        }
    }
}

