/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.processing.conduit;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlock;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlockEntity;
import net.davio.aquaticambitions.registry.CAAPartials;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MechanicalConduitRenderer
extends SafeBlockEntityRenderer<MechanicalConduitBlockEntity> {
    public MechanicalConduitRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(MechanicalConduitBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        MechanicalConduitBlock.ConduitPowerLevel conduitLevel = be.getConduitLevelFromBlock();
        Level level = be.m_58904_();
        BlockState blockState = be.m_58900_();
        float animation = be.eyeAnimation.getValue(partialTicks) * 0.175f;
        float eyeAngle = AngleHelper.rad((double)be.eyeAngle.getValue(partialTicks));
        int hashCode = ((Object)((Object)be)).hashCode();
        this.renderShared(ms, null, bufferSource, level, blockState, conduitLevel, animation, eyeAngle, hashCode);
    }

    private void renderShared(PoseStack ms, @Nullable PoseStack modelTransform, MultiBufferSource bufferSource, Level level, BlockState blockState, MechanicalConduitBlock.ConduitPowerLevel conduitLevel, float animation, float playerTrackAngle, int hashCode) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = conduitLevel.isAwakened() ? 64.0f : 16.0f;
        float offset = Mth.m_14031_((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float eyeY = offset - animation * 0.75f + (conduitLevel.isAwakened() ? 0.2f : 0.0f);
        float rotateYZ = (float)Math.PI / 180 * (time * 2.0f) % 360.0f;
        float rotateX = 0.5235988f * Mth.m_14031_((float)(time * 2.0f % 360.0f * ((float)Math.PI / 180)));
        VertexConsumer solid = bufferSource.m_6299_(RenderType.m_110451_());
        VertexConsumer cutout = bufferSource.m_6299_(RenderType.m_110457_());
        ms.m_85836_();
        SuperByteBuffer headBuffer = CachedBuffers.partial((PartialModel)CAAPartials.CONDUIT_EYE, (BlockState)blockState);
        if (modelTransform != null) {
            headBuffer.transform(modelTransform);
        }
        headBuffer.translate(0.0f, eyeY, 0.0f);
        MechanicalConduitRenderer.draw(headBuffer, playerTrackAngle, ms, bufferSource.m_6299_(RenderType.m_110463_()));
        if (conduitLevel.isAwakened()) {
            SuperByteBuffer cageBuffer = CachedBuffers.partial((PartialModel)CAAPartials.CONDUIT_CAGE, (BlockState)blockState);
            if (modelTransform != null) {
                cageBuffer.transform(modelTransform);
            }
            ((SuperByteBuffer)((SuperByteBuffer)cageBuffer.translate(0.0f, eyeY, 0.0f)).rotateXCentered(rotateX)).rotateZCentered(rotateYZ);
            MechanicalConduitRenderer.draw(cageBuffer, rotateYZ, ms, bufferSource.m_6299_(RenderType.m_110463_()));
        } else {
            SuperByteBuffer inactiveConduitBuffer = CachedBuffers.partial((PartialModel)CAAPartials.INACTIVE_CONDUIT, (BlockState)blockState);
            if (modelTransform != null) {
                inactiveConduitBuffer.transform(modelTransform);
            }
            inactiveConduitBuffer.translate(0.0f, eyeY, 0.0f);
            MechanicalConduitRenderer.draw(inactiveConduitBuffer, playerTrackAngle, ms, bufferSource.m_6299_(RenderType.m_110463_()));
        }
        ms.m_85849_();
    }

    private static void draw(SuperByteBuffer buffer, float horizontalAngle, PoseStack ms, VertexConsumer vc) {
        ((SuperByteBuffer)buffer.rotateCentered(horizontalAngle, Direction.UP)).light(0xF000F0).renderInto(ms, vc);
    }
}

