/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network.packets;

import com.pedrorok.hypertube.network.Packet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record EntityTravelDirDataPacket(int entityId, float yaw, float pitch) implements Packet<EntityTravelDirDataPacket>
{
    public EntityTravelDirDataPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readFloat(), buf.readFloat());
    }

    public static EntityTravelDirDataPacket create(Entity entity) {
        return new EntityTravelDirDataPacket(entity.m_19879_(), entity.m_146908_(), entity.m_146909_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(EntityTravelDirDataPacket packet) {
        if (Minecraft.m_91087_().f_91074_.m_19879_() == packet.entityId) {
            return;
        }
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId);
        if (entity == null) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        entity.m_146922_(packet.yaw);
        entity.m_146926_(packet.pitch);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
    }

    @Override
    public void execute(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> EntityTravelDirDataPacket.handleClient(this));
        ctx.get().setPacketHandled(true);
    }
}

