/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network.packets;

import com.pedrorok.hypertube.core.travel.ClientTravelPathMover;
import com.pedrorok.hypertube.network.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record SpeedChangePacket(int entityId, double newSpeed) implements Packet<SpeedChangePacket>
{
    public SpeedChangePacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readDouble());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.newSpeed);
    }

    @Override
    public void execute(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientTravelPathMover.updateEntitySpeed(this));
        ctx.get().setPacketHandled(true);
    }
}

