/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.base.PartialBlockDamageSaveData;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class PartialBlockDamageManager {
    private Map<ResourceKey<Level>, Map<BlockPos, Integer>> blockDamage;
    private Map<ResourceKey<Level>, Map<BlockPos, BlockState>> blockStates;
    private PartialBlockDamageSaveData savedata;

    public PartialBlockDamageManager() {
        this.cleanUp();
    }

    public void playerLogin(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            this.loadDamageData(splayer.m_20194_());
        }
    }

    public void playerLogout(Player player) {
    }

    public void levelLoaded(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        this.cleanUp();
        this.savedata = null;
        this.loadDamageData(server);
    }

    private void cleanUp() {
        this.blockDamage = new HashMap<ResourceKey<Level>, Map<BlockPos, Integer>>();
    }

    private void loadDamageData(MinecraftServer server) {
        if (this.savedata != null) {
            return;
        }
        this.savedata = PartialBlockDamageSaveData.load(server);
        this.blockDamage = this.savedata.getBlockDamage();
        this.blockStates = new Object2ObjectLinkedOpenHashMap();
    }

    public void tick(Level level) {
        ResourceKey dimension = level.m_46472_();
        if (!this.blockDamage.containsKey(dimension)) {
            return;
        }
        Map<BlockPos, Integer> levelSet = this.blockDamage.get(dimension);
        Object2ObjectLinkedOpenHashMap blockStateSet = this.blockStates.get(dimension);
        if (levelSet.isEmpty()) {
            this.blockDamage.remove(dimension);
            this.blockStates.remove(dimension);
            return;
        }
        if (level.m_46467_() % 20L != 0L) {
            return;
        }
        Object2ObjectLinkedOpenHashMap newSet = new Object2ObjectLinkedOpenHashMap();
        Iterator<Map.Entry<BlockPos, Integer>> iter = levelSet.entrySet().iterator();
        while (iter.hasNext()) {
            int newPart;
            double toughnessRec;
            int oldPart;
            boolean blockChanged;
            Map.Entry<BlockPos, Integer> entry = iter.next();
            BlockPos pos = entry.getKey();
            BlockState state = level.m_46745_(pos).m_8055_(pos);
            int oldProgress = entry.getValue();
            boolean bl = blockChanged = blockStateSet != null && blockStateSet.containsKey(pos) && !blockStateSet.get(pos).equals(state);
            if (state.m_247087_() || !state.m_280296_() || state.m_60800_((BlockGetter)level, pos) == -1.0f || blockChanged) {
                if (oldProgress > 0) {
                    level.m_6801_(-1, pos, -1);
                }
                iter.remove();
                continue;
            }
            if (blockStateSet == null) {
                blockStateSet = new Object2ObjectLinkedOpenHashMap();
                this.blockStates.put((ResourceKey<Level>)dimension, (Map<BlockPos, BlockState>)blockStateSet);
            }
            blockStateSet.put(pos, state);
            int newProgress = oldProgress - 3;
            if (newProgress <= 0) {
                CBCUtils.sendCustomBlockDamage(level, pos, -1);
                iter.remove();
            } else {
                newSet.put(entry.getKey(), newProgress);
            }
            if ((oldPart = (int)Math.floor((double)oldProgress * (toughnessRec = 1.0 / BlockArmorPropertiesHandler.getProperties(state).toughness(level, state, pos, true)))) - (newPart = (int)Math.floor((double)newProgress * toughnessRec)) <= 0) continue;
            CBCUtils.sendCustomBlockDamage(level, pos, newPart);
        }
        levelSet.putAll((Map<BlockPos, Integer>)newSet);
        if (blockStateSet != null && blockStateSet.isEmpty()) {
            this.blockStates.remove(dimension);
        }
        this.markDirty();
    }

    public void markDirty() {
        if (this.savedata != null) {
            this.savedata.m_77762_();
        }
    }

    public boolean damageBlock(BlockPos pos, int added, BlockState state, Level level) {
        return this.damageBlock(pos, added, state, level, PartialBlockDamageManager::destroyBlockDefault);
    }

    public static void voidBlock(Level level, BlockPos pos) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public static void destroyBlockDefault(Level level, BlockPos pos) {
        level.m_46961_(pos, false);
    }

    public boolean damageBlock(BlockPos pos, int added, BlockState state, Level level, BiConsumer<Level, BlockPos> onDestroy) {
        Map levelSet = this.blockDamage.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new Object2ObjectLinkedOpenHashMap());
        int oldProgress = levelSet.getOrDefault(pos, 0);
        levelSet.merge(pos, added, Integer::sum);
        double toughnessRec = 1.0 / BlockArmorPropertiesHandler.getProperties(state).toughness(level, state, pos, true);
        int oldPart = (int)Math.floor((double)oldProgress * toughnessRec);
        int newPart = (int)Math.floor((double)((Integer)levelSet.get(pos)).intValue() * toughnessRec);
        boolean destroyed = false;
        if (newPart >= 10) {
            if (!level.m_5776_()) {
                onDestroy.accept(level, pos);
            }
            levelSet.remove(pos);
            Map<BlockPos, BlockState> stateSet = this.blockStates.get(level.m_46472_());
            if (stateSet != null) {
                stateSet.remove(pos);
            }
            CBCUtils.sendCustomBlockDamage(level, pos, -1);
            destroyed = true;
        } else if (newPart - oldPart > 0) {
            CBCUtils.sendCustomBlockDamage(level, pos, newPart);
        }
        this.markDirty();
        return destroyed;
    }
}

