/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.CBCContraptionRotationState;
import rbasamoyai.createbigcannons.cannons.InteractableCannonBlock;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;

public class PitchOrientedContraptionEntity
extends OrientedContraptionEntity {
    private BlockPos controllerPos;
    private boolean updatesOwnRotation;

    public PitchOrientedContraptionEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public static PitchOrientedContraptionEntity create(Level level, Contraption contraption, Direction initialOrientation, boolean updatesOwnRotation) {
        PitchOrientedContraptionEntity entity = (PitchOrientedContraptionEntity)CBCEntityTypes.PITCH_ORIENTED_CONTRAPTION.create(level);
        entity.setContraption(contraption);
        entity.setInitialOrientation(initialOrientation);
        entity.startAtInitialYaw();
        entity.updatesOwnRotation = updatesOwnRotation;
        return entity;
    }

    public static PitchOrientedContraptionEntity create(Level level, Contraption contraption, Direction initialOrientation, ControlPitchContraption.Block block) {
        PitchOrientedContraptionEntity poce = PitchOrientedContraptionEntity.create(level, contraption, initialOrientation, true);
        poce.controllerPos = block.getControllerBlockPos();
        return poce;
    }

    protected void readAdditional(CompoundTag compound, boolean spawnPacket) {
        super.readAdditional(compound, spawnPacket);
        if (compound.m_128441_("ControllerRelative")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("ControllerRelative")).m_121955_((Vec3i)this.m_20183_());
        } else {
            BlockEntity blockEntity = this.m_9236_().m_7702_(this.m_20183_().m_6625_(2));
            if (blockEntity instanceof ControlPitchContraption.Block) {
                ControlPitchContraption.Block controller = (ControlPitchContraption.Block)blockEntity;
                if (!this.m_20159_()) {
                    this.controllerPos = controller.getControllerBlockPos();
                }
            }
        }
        this.updatesOwnRotation = compound.m_128471_("UpdatesOwnRotation");
    }

    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        if (this.controllerPos != null) {
            compound.m_128365_("ControllerRelative", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos.m_121996_((Vec3i)this.m_20183_())));
        }
        compound.m_128379_("UpdatesOwnRotation", this.updatesOwnRotation);
    }

    public ControlPitchContraption getController() {
        ControlPitchContraption controller;
        if (this.controllerPos != null) {
            ControlPitchContraption controller2;
            if (!this.m_9236_().m_46749_(this.controllerPos)) {
                return null;
            }
            BlockEntity blockEntity = this.m_9236_().m_7702_(this.controllerPos);
            return blockEntity instanceof ControlPitchContraption ? (controller2 = (ControlPitchContraption)blockEntity) : null;
        }
        Entity entity = this.m_20202_();
        return entity instanceof ControlPitchContraption ? (controller = (ControlPitchContraption)entity) : null;
    }

    protected void tickContraption() {
        ControlPitchContraption controller;
        super.tickContraption();
        if (this.updatesOwnRotation) {
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
        }
        this.contraption.anchor = this.m_20183_();
        Level level = this.m_9236_();
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption mounted = (AbstractMountedCannonContraption)contraption;
            mounted.tick(level, this);
        }
        if ((controller = this.getController()) == null) {
            if (!level.f_46443_) {
                this.disassemble();
            }
            return;
        }
        if (!controller.isAttachedTo((AbstractContraptionEntity)this)) {
            controller.attach(this);
            if (level.f_46443_) {
                this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
        }
    }

    public void handleAnimation() {
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption mounted = (AbstractMountedCannonContraption)contraption;
            mounted.animate();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float maximumDepression() {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof AbstractMountedCannonContraption)) return 90.0f;
        AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
        if (this.getController() == null) return 90.0f;
        float f = cannon.maximumDepression(this.getController());
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float maximumElevation() {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof AbstractMountedCannonContraption)) return 90.0f;
        AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
        if (this.getController() == null) return 90.0f;
        float f = cannon.maximumElevation(this.getController());
        return f;
    }

    protected void onContraptionStalled() {
        ControlPitchContraption controller = this.getController();
        if (controller != null) {
            controller.onStall();
        }
        super.onContraptionStalled();
    }

    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return new CBCContraptionRotationState(this);
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, Entity riding, boolean isOnCoupling) {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        float prevYaw = this.yaw;
        super.m_7350_(key);
        this.yaw = prevYaw;
    }

    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate((Vec3)localPos, (double)this.m_5686_(partialTicks), (Direction.Axis)(this.getInitialOrientation().m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        localPos = VecHelper.rotate((Vec3)localPos, (double)this.m_5675_(partialTicks), (Direction.Axis)Direction.Axis.Y);
        localPos = VecHelper.rotate((Vec3)localPos, (double)this.getInitialYaw(), (Direction.Axis)Direction.Axis.Y);
        return localPos;
    }

    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate((Vec3)localPos, (double)(-this.getInitialYaw()), (Direction.Axis)Direction.Axis.Y);
        localPos = VecHelper.rotate((Vec3)localPos, (double)(-this.m_5675_(partialTicks)), (Direction.Axis)Direction.Axis.Y);
        localPos = VecHelper.rotate((Vec3)localPos, (double)(-this.m_5686_(partialTicks)), (Direction.Axis)(this.getInitialOrientation().m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        return localPos;
    }

    public float getRotationCoefficient() {
        float f;
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            f = Math.max(1.0f / cannon.getWeightForStress(), 0.1f);
        } else {
            f = 0.1f;
        }
        return f;
    }

    public void addSittingPassenger(Entity passenger, int seatIndex) {
        Mob mob;
        Entity entity;
        if (passenger instanceof Mob && (entity = (mob = (Mob)passenger).m_21524_()) instanceof Player) {
            Player player = (Player)entity;
            this.addSittingPassenger((Entity)player, seatIndex);
        }
        super.addSittingPassenger(passenger, seatIndex);
    }

    protected void m_20348_(Entity entity) {
        super.m_20348_(entity);
        Direction dir = this.getInitialOrientation();
        boolean flag = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
        entity.m_146926_(flag ? -this.pitch : this.prevPitch);
        entity.m_146922_(this.yaw);
        entity.f_19860_ = flag ? -this.prevPitch : this.prevPitch;
        entity.f_19859_ = this.prevYaw;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction function) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Vec3 transformedVector = this.getPassengerPosition(passenger, 1.0f);
        if ((transformedVector = this.processRiderPositionHook(passenger, transformedVector)) == null) {
            return;
        }
        passenger.m_6034_(transformedVector.f_82479_, transformedVector.f_82480_, transformedVector.f_82481_);
    }

    @Nullable
    protected Vec3 processRiderPositionHook(Entity passenger, @Nullable Vec3 original) {
        return original;
    }

    public Vec3 getPassengerPosition(Entity passenger, float partialTicks) {
        Contraption contraption;
        if (passenger != this.m_6688_() || !((contraption = this.contraption) instanceof AbstractMountedCannonContraption)) {
            return super.getPassengerPosition(passenger, partialTicks);
        }
        AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
        BlockPos seat = cannon.getSeatPos(passenger);
        if (seat == null) {
            return null;
        }
        Vec3 normal = new Vec3(this.getInitialOrientation().m_253071_());
        return this.toGlobalVector(Vec3.m_82512_((Vec3i)seat).m_82549_(normal.m_82490_(-0.25)), partialTicks);
    }

    public Vec3 m_7688_(LivingEntity entityLiving) {
        ControlPitchContraption controller = this.getController();
        Vec3 superResult = super.m_7688_(entityLiving);
        return controller != null ? Vec3.m_82512_((Vec3i)controller.getDismountPositionForContraption(this)) : superResult;
    }

    public BlockPos getSeatPos(Entity passenger) {
        return ((AbstractMountedCannonContraption)this.contraption).getSeatPos(passenger);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Player player;
        Entity entity = this.m_146895_();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    public boolean canBeTurnedByController(ControlPitchContraption control) {
        AbstractMountedCannonContraption cannon;
        Contraption contraption = this.contraption;
        return contraption instanceof AbstractMountedCannonContraption && (cannon = (AbstractMountedCannonContraption)contraption).canBeTurnedByController(control);
    }

    public void tryFiringShot() {
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            contraption = this.m_9236_();
            if (contraption instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)contraption;
                cannon.fireShot(slevel, this);
            }
        }
    }

    public boolean handlePlayerInteraction(Player player, BlockPos localPos, Direction side, InteractionHand interactionHand) {
        BlockEntity be = null;
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            be = cannon.presentBlockEntities.get(localPos);
        }
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)this.contraption.getBlocks().get(localPos);
        Contraption contraption2 = this.contraption;
        if (contraption2 instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption2;
            contraption2 = info.f_74676_().m_60734_();
            if (contraption2 instanceof InteractableCannonBlock) {
                InteractableCannonBlock cBlock = (InteractableCannonBlock)contraption2;
                if (interactionHand == InteractionHand.MAIN_HAND && cBlock.onInteractWhileAssembled(player, localPos, side, interactionHand, this.m_9236_(), cannon, be, info, this)) {
                    return true;
                }
            }
        }
        return super.handlePlayerInteraction(player, localPos, side, interactionHand);
    }

    public boolean m_6128_() {
        return true;
    }
}

