/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.config;

import com.simibubi.create.api.stress.BlockStressValues;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import rbasamoyai.createbigcannons.config.CBCCfgClient;
import rbasamoyai.createbigcannons.config.CBCCfgCommon;
import rbasamoyai.createbigcannons.config.CBCCfgServer;
import rbasamoyai.createbigcannons.config.CBCCfgStress;

public class CBCConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static CBCCfgClient client;
    private static CBCCfgCommon common;
    private static CBCCfgServer server;

    public static CBCCfgClient client() {
        return client;
    }

    public static CBCCfgCommon common() {
        return common;
    }

    public static CBCCfgServer server() {
        return server;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register(BiConsumer<ModConfig.Type, ForgeConfigSpec> cons) {
        client = CBCConfigs.register(CBCCfgClient::new, ModConfig.Type.CLIENT);
        common = CBCConfigs.register(CBCCfgCommon::new, ModConfig.Type.COMMON);
        server = CBCConfigs.register(CBCCfgServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            cons.accept(pair.getKey(), pair.getValue().specification);
        }
        CBCCfgStress stress = CBCConfigs.server().kinetics.stress;
        BlockStressValues.IMPACTS.registerProvider(stress::getImpact);
        BlockStressValues.CAPACITIES.registerProvider(stress::getCapacity);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }
}

