/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.base.PropertySetter;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;

public class CannonCastShape {
    private static final int INGOT_SIZE_MB = 90;
    public static final CannonCastShape VERY_SMALL = CannonCastShape.register("very_small", new CannonCastShape(630, 12, (NonNullSupplier<? extends Block>)CBCBlocks.VERY_SMALL_CAST_MOULD, new PropertySetter[0]));
    public static final CannonCastShape SMALL = CannonCastShape.register("small", new CannonCastShape(810, 14, (NonNullSupplier<? extends Block>)CBCBlocks.SMALL_CAST_MOULD, new PropertySetter[0]));
    public static final CannonCastShape MEDIUM = CannonCastShape.register("medium", new CannonCastShape(1080, 16, (NonNullSupplier<? extends Block>)CBCBlocks.MEDIUM_CAST_MOULD, new PropertySetter[0]));
    public static final CannonCastShape LARGE = CannonCastShape.register("large", new CannonCastShape(1260, 18, (NonNullSupplier<? extends Block>)CBCBlocks.LARGE_CAST_MOULD, new PropertySetter[0]));
    public static final CannonCastShape VERY_LARGE = CannonCastShape.register("very_large", new CannonCastShape(1800, 20, (NonNullSupplier<? extends Block>)CBCBlocks.VERY_LARGE_CAST_MOULD, new PropertySetter[0]));
    public static final CannonCastShape CANNON_END = CannonCastShape.register("cannon_end", new CannonCastShape(810, 16, (NonNullSupplier<? extends Block>)CBCBlocks.CANNON_END_CAST_MOULD, new PropertySetter[0]));
    public static final CannonCastShape SLIDING_BREECH = CannonCastShape.register("sliding_breech", new CannonCastShape(810, 16, (NonNullSupplier<? extends Block>)CBCBlocks.SLIDING_BREECH_CAST_MOULD, PropertySetter.of(DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE, false)));
    public static final CannonCastShape SCREW_BREECH = CannonCastShape.register("screw_breech", new CannonCastShape(810, 16, (NonNullSupplier<? extends Block>)CBCBlocks.SCREW_BREECH_CAST_MOULD, true, false, (PropertySetter<?>[])new PropertySetter[0]));
    public static final CannonCastShape DROP_MORTAR_END = CannonCastShape.register("drop_mortar_end", new CannonCastShape(810, 16, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50016_), new PropertySetter[0]));
    public static final CannonCastShape AUTOCANNON_BARREL = CannonCastShape.register("autocannon_barrel", new CannonCastShape(270, 4, (NonNullSupplier<? extends Block>)CBCBlocks.AUTOCANNON_BARREL_CAST_MOULD, false, false, (PropertySetter<?>[])new PropertySetter[]{PropertySetter.of(BlockStateProperties.f_61372_, Direction.UP)}));
    public static final CannonCastShape AUTOCANNON_BARREL_FLANGED = CannonCastShape.register("autocannon_barrel_flanged", new CannonCastShape(270, 4, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50016_), false, false, new PropertySetter[0]));
    public static final CannonCastShape AUTOCANNON_BREECH = CannonCastShape.register("autocannon_breech", new CannonCastShape(360, 8, (NonNullSupplier<? extends Block>)CBCBlocks.AUTOCANNON_BREECH_CAST_MOULD, false, false, (PropertySetter<?>[])new PropertySetter[]{PropertySetter.of(BlockStateProperties.f_61372_, Direction.UP)}));
    public static final CannonCastShape AUTOCANNON_RECOIL_SPRING = CannonCastShape.register("autocannon_recoil_spring", new CannonCastShape(360, 6, (NonNullSupplier<? extends Block>)CBCBlocks.AUTOCANNON_RECOIL_SPRING_CAST_MOULD, false, false, (PropertySetter<?>[])new PropertySetter[]{PropertySetter.of(BlockStateProperties.f_61372_, Direction.UP)}));
    private final int fluidSize;
    private final int diameter;
    private final NonNullSupplier<? extends Block> castMould;
    private final boolean isLarge;
    private final PropertySetter<?>[] properties;
    private final boolean texturesCanConnect;
    private Block resolvedCastMould;

    public CannonCastShape(int fluidSizeForge, int diameter, NonNullSupplier<? extends Block> castMould, PropertySetter<?> ... properties) {
        this(fluidSizeForge, diameter, castMould, true, true, properties);
    }

    public CannonCastShape(int fluidSizeForge, int diameter, NonNullSupplier<? extends Block> castMould, boolean large, boolean texturesCanConnect, PropertySetter<?> ... properties) {
        this.fluidSize = IndexPlatform.convertFluid(fluidSizeForge);
        this.diameter = diameter;
        this.castMould = castMould;
        this.isLarge = large;
        this.properties = properties;
        this.texturesCanConnect = texturesCanConnect;
    }

    public int fluidSize() {
        return this.fluidSize;
    }

    public int diameter() {
        return this.diameter;
    }

    public boolean isLarge() {
        return this.isLarge;
    }

    public boolean texturesCanConnect() {
        return this.texturesCanConnect;
    }

    public Block castMould() {
        if (this.resolvedCastMould == null) {
            this.resolvedCastMould = (Block)this.castMould.get();
            if (this.resolvedCastMould == null) {
                this.resolvedCastMould = Blocks.f_50016_;
            }
        }
        return this.resolvedCastMould;
    }

    public BlockState applyTo(BlockState state) {
        for (PropertySetter<?> setter : this.properties) {
            state = setter.applyTo(state);
        }
        return state;
    }

    public String toString() {
        return "CannonCastShape[" + String.valueOf(CBCRegistries.cannonCastShapes().m_7981_((Object)this)) + ",fluidSize=" + this.fluidSize + ",diameter=" + this.diameter + "]";
    }

    public static void register() {
    }

    private static CannonCastShape register(String id, CannonCastShape shape) {
        return (CannonCastShape)Registry.m_122965_(CBCRegistries.cannonCastShapes(), (ResourceLocation)CreateBigCannons.resource(id), (Object)shape);
    }
}

