/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.accessories;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegistryObject;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.accessories.AccessoriesCompatClient;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;

public class AccessoriesCompat
implements ICompat {
    private final Set<String> backpackAccessoriesSlotNames = new CopyOnWriteArraySet<String>();
    private long lastTagsRefresh = -1L;
    private static final int TAGS_REFRESH_COOLDOWN = 100;
    private static final Accessory NOT_EQUIPPABLE_FROM_USE_ACCESSORY = new Accessory(){

        public boolean canEquipFromUse(ItemStack stack) {
            return false;
        }
    };

    public void setup() {
        this.addPlayerInventoryHandlers();
        ModItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(BackpackItem.class::isInstance).forEach(item -> AccessoriesAPI.registerAccessory((Item)item, (Accessory)NOT_EQUIPPABLE_FROM_USE_ACCESSORY));
        if (FMLEnvironment.dist.isClient()) {
            AccessoriesCompatClient.registerRenderers();
        }
    }

    private void addPlayerInventoryHandlers() {
        PlayerInventoryProvider.get().addPlayerInventoryHandler("accessories", this::getAccessoriesSlotTags, (player, identifier) -> AccessoriesCompat.getFromAccessoriesStorage((LivingEntity)player, identifier, AccessoriesContainer::getSize, 0), (player, identifier, slot) -> AccessoriesCompat.getFromAccessoriesStorage((LivingEntity)player, identifier, storage -> storage.getAccessories().m_8020_(slot), ItemStack.f_41583_), false, true, true, true);
    }

    private Set<String> getAccessoriesSlotTags(Player player) {
        long gameTime = player.m_9236_().m_46467_();
        if (this.lastTagsRefresh + 100L < gameTime) {
            this.lastTagsRefresh = gameTime;
            this.backpackAccessoriesSlotNames.clear();
            this.backpackAccessoriesSlotNames.addAll(AccessoriesCapability.getOptionally((LivingEntity)player).map(capability -> capability.getContainers().keySet()).orElse(Collections.emptySet()));
        }
        return this.backpackAccessoriesSlotNames;
    }

    public static <T> T getFromAccessoriesStorage(LivingEntity livingEntity, String identifier, Function<AccessoriesContainer, T> getFromStorage, T defaultValue) {
        return (T)AccessoriesCapability.getOptionally((LivingEntity)livingEntity).map(cap -> {
            AccessoriesContainer storage = (AccessoriesContainer)cap.getContainers().get(identifier);
            if (storage == null) {
                return defaultValue;
            }
            return getFromStorage.apply(storage);
        }).orElse(defaultValue);
    }
}

