/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.CeilingFanBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CeilingFanBlockEntity
extends ElectricityModuleBlockEntity
implements ILevelAudio {
    public static final float MAX_SPEED = 50.0f;
    private static final float ACCELERATION = 1.25f;
    private static final float RESISTANCE = 0.98f;
    private static final AABB[] DAMAGE_BOXES = (AABB[])Util.m_137537_(() -> {
        AABB[] boxes = new AABB[Direction.values().length];
        boxes[Direction.UP.m_122411_()] = new AABB(-0.625, 0.5, -0.625, 1.625, 0.625, 1.625);
        boxes[Direction.DOWN.m_122411_()] = new AABB(-0.625, 0.375, -0.625, 1.625, 0.5, 1.625);
        boxes[Direction.NORTH.m_122411_()] = new AABB(-0.625, -0.625, 0.375, 1.625, 1.625, 0.5);
        boxes[Direction.EAST.m_122411_()] = new AABB(0.5, -0.625, -0.625, 0.625, 1.625, 1.625);
        boxes[Direction.SOUTH.m_122411_()] = new AABB(-0.625, -0.625, 0.5, 1.625, 1.625, 0.625);
        boxes[Direction.WEST.m_122411_()] = new AABB(0.375, -0.625, -0.625, 0.5, 1.625, 1.625);
        return boxes;
    });
    protected final Vec3 audioPosition;
    private float bladeSpeed;
    private float bladeRotation;
    private float lastBladeRotation;

    public CeilingFanBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CEILING_FAN.get(), pos, state);
        this.audioPosition = pos.m_252807_().m_82520_(0.0, 0.375, 0.0);
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)BlockStateProperties.f_61448_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BlockStateProperties.f_61448_)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    private void updateAnimation() {
        this.lastBladeRotation = this.bladeRotation;
        if (this.isNodePowered()) {
            this.bladeSpeed = Math.min(this.bladeSpeed + 1.25f, this.getMaxSpeed());
        }
        this.bladeSpeed *= 0.98f;
        this.bladeRotation += this.bladeSpeed;
        if (this.bladeRotation > 360.0f) {
            this.bladeRotation -= 360.0f;
            this.lastBladeRotation -= 360.0f;
        }
    }

    public float getRotation(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.lastBladeRotation, (float)this.bladeRotation);
    }

    private void performDamage(Level level) {
        if (this.isNodePowered()) {
            Direction direction = this.getDirection();
            AABB box = this.getDamageBox(direction).m_82338_(this.m_58899_());
            List entities = level.m_45976_(LivingEntity.class, box);
            entities.forEach(entity -> {
                entity.m_6469_(Services.BLOCK.ceilingFanDamageSource(level), 0.5f);
                entity.m_6703_(entity);
            });
        }
    }

    public AABB getDamageBox(Direction direction) {
        return DAMAGE_BOXES[direction.m_122411_()];
    }

    public Direction getDirection() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)CeilingFanBlock.FACING)) {
            return (Direction)state.m_61143_((Property)CeilingFanBlock.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    public void moduleTick(Level level) {
        super.moduleTick(level);
        if (!level.f_46443_) {
            this.performDamage(level);
        } else {
            this.updateAnimation();
            AudioManager.get().playLevelAudio(this);
        }
    }

    @Override
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.BLOCK_CEILING_FAN_SPIN.get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.bladeSpeed > 5.0f && !this.m_58901_();
    }

    @Override
    public float getAudioVolume() {
        return this.bladeSpeed / 50.0f;
    }

    @Override
    public float getAudioPitch() {
        return 0.5f + this.bladeSpeed / 50.0f;
    }

    @Override
    public int getAudioHash() {
        return this.f_58858_.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return 16.0;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level.m_5776_() && this.isNodePowered()) {
            this.bladeSpeed = this.getMaxSpeed();
        }
    }

    private float getMaxSpeed() {
        return ((Double)Config.CLIENT.ceilingFanMaxSpeed.get()).floatValue();
    }
}

