/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.feature.mcfunction_profiling;

import com.google.common.base.Stopwatch;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.commands.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerFunctionManager;
import org.embeddedt.modernfix.duck.IProfilingServerFunctionManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerFunctionManager.class})
public class ServerFunctionManagerMixin
implements IProfilingServerFunctionManager {
    @Shadow
    @Final
    private static ResourceLocation f_136099_;
    private final Map<ResourceLocation, Stopwatch> mfix$functionWatches = new Object2ObjectOpenHashMap();

    @Inject(method={"executeTagFunctions"}, at={@At(value="HEAD")})
    private void resetWatches(Collection<CommandFunction> functionObjects, ResourceLocation identifier, CallbackInfo ci) {
        this.mfix$functionWatches.values().forEach(Stopwatch::reset);
    }

    @Inject(method={"executeTagFunctions"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/ServerFunctionManager;execute(Lnet/minecraft/commands/CommandFunction;Lnet/minecraft/commands/CommandSourceStack;)I")})
    private void startWatch(Collection<CommandFunction> functionObjects, ResourceLocation identifier, CallbackInfo ci, @Local(ordinal=0) CommandFunction function, @Share(value="stopwatch") LocalRef<Stopwatch> watchRef) {
        watchRef.set(null);
        if (identifier == f_136099_) {
            Stopwatch watch = this.mfix$functionWatches.computeIfAbsent(function.m_77981_(), i -> Stopwatch.createUnstarted());
            watch.start();
            watchRef.set((Object)watch);
        }
    }

    @Inject(method={"executeTagFunctions"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/ServerFunctionManager;execute(Lnet/minecraft/commands/CommandFunction;Lnet/minecraft/commands/CommandSourceStack;)I", shift=At.Shift.AFTER)})
    private void stopWatch(Collection<CommandFunction> functionObjects, ResourceLocation identifier, CallbackInfo ci, @Share(value="stopwatch") LocalRef<Stopwatch> watchRef) {
        Stopwatch watch = (Stopwatch)watchRef.get();
        if (watch != null && watch.isRunning()) {
            watch.stop();
        }
    }

    @Inject(method={"executeTagFunctions"}, at={@At(value="RETURN")})
    private void pruneUnusedWatches(Collection<CommandFunction> functionObjects, ResourceLocation identifier, CallbackInfo ci) {
        this.mfix$functionWatches.values().removeIf(watch -> watch.elapsed().isZero());
    }

    @Override
    public String mfix$getProfilingResults() {
        ArrayList<Map.Entry<ResourceLocation, Stopwatch>> list = new ArrayList<Map.Entry<ResourceLocation, Stopwatch>>(this.mfix$functionWatches.entrySet());
        list.sort(Comparator.comparing(e -> ((Stopwatch)e.getValue()).elapsed()).reversed());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ResourceLocation, Stopwatch> entry : list) {
            sb.append(entry.getKey().toString());
            sb.append(" - ");
            sb.append(entry.getValue().toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

