/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.fix_loop_spin_waiting;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.thread.BlockableEventLoop;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={MinecraftServer.class}, priority=500)
public abstract class MinecraftServerMixin
extends BlockableEventLoop<Runnable> {
    @Shadow
    private long f_129726_;
    @Unique
    private boolean mfix$isWaitingForNextTick = false;

    protected MinecraftServerMixin(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"waitUntilNextTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;managedBlock(Ljava/util/function/BooleanSupplier;)V")})
    private void managedBlock(MinecraftServer instance, BooleanSupplier isDone, Operation<Void> original) {
        try {
            this.mfix$isWaitingForNextTick = true;
            original.call(new Object[]{instance, isDone});
        }
        finally {
            this.mfix$isWaitingForNextTick = false;
        }
    }

    protected void m_5667_() {
        if (this.mfix$isWaitingForNextTick) {
            LockSupport.parkNanos("waiting for tasks", this.f_129726_ * 1000000L - Util.m_137569_());
        } else {
            super.m_5667_();
        }
    }
}

