/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity.container;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegPlaceRecipe;
import umpaz.brewinandchewin.common.block.entity.container.KegResultSlot;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.registry.BnCBlocks;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class KegMenu
extends RecipeBookMenu<KegRecipeWrapper> {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_TANKARD = new ResourceLocation("brewinandchewin", "item/empty_container_slot_tankard");
    public final KegBlockEntity blockEntity;
    public final ItemStackHandler inventory;
    public final FluidTank kegTank;
    private final ContainerData kegData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public KegMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, KegMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public KegMenu(int windowId, Inventory playerInventory, KegBlockEntity blockEntity, ContainerData kegDataIn) {
        super((MenuType)BnCMenuTypes.KEG.get(), windowId);
        int column;
        this.blockEntity = blockEntity;
        this.inventory = blockEntity.getInventory();
        this.kegTank = blockEntity.getFluidTank();
        this.kegData = kegDataIn;
        this.level = playerInventory.f_35978_.m_9236_();
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        int startX = 8;
        int startY = 18;
        int inputStartX = 39;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 2; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 2 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 4, 91, 55){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_CONTAINER_SLOT_TANKARD);
            }
        });
        this.m_38897_((Slot)new KegResultSlot((IItemHandler)this.inventory, 5, 124, 55));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.m_38884_(kegDataIn);
    }

    private static KegBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof KegBlockEntity) {
            return (KegBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean m_6875_(Player playerIn) {
        return KegMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)BnCBlocks.KEG.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexContainerInput = 4;
        int indexOutput = 5;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        Slot slot = (Slot)this.f_38839_.get(index);
        ItemStack slotStackCopy = ItemStack.f_41583_;
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            slotStackCopy = slotStack.m_41777_();
            if (index == indexOutput) {
                if (!this.m_38903_(slotStack, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index > indexOutput) {
                boolean isValidContainer;
                boolean bl = isValidContainer = slotStack.m_150930_(this.blockEntity.getInventory().getStackInSlot(4).m_41720_()) || this.blockEntity.getPouringRecipe(slotStack).isPresent();
                if (isValidContainer && !this.m_38903_(slotStack, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 0, indexContainerInput, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(slotStack, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == slotStackCopy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public int getFermentProgressionScaled() {
        int i = this.kegData.m_6413_(0);
        int j = this.kegData.m_6413_(1);
        return j != 0 && i != 0 ? i * 22 / j : 0;
    }

    public float getProgression() {
        return this.kegData.m_6413_(0);
    }

    public int getKegTemperature() {
        return this.kegData.m_6413_(2);
    }

    public boolean isFermenting() {
        Optional<KegFermentingRecipe> recipe = this.blockEntity.getRecipeWithoutTemperature();
        return recipe.isPresent() && KegBlockEntity.isValidTemp(this.getKegTemperature(), recipe.get().getTemperature());
    }

    public void m_6951_(boolean placeAll, Recipe<?> recipe, ServerPlayer player) {
        new KegPlaceRecipe(this, player.m_20194_().m_129894_()).m_135434_(player, recipe, placeAll);
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.m_36466_(this.inventory.getStackInSlot(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 4; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super KegRecipeWrapper> recipe) {
        return recipe.m_5818_((Container)new KegRecipeWrapper((IItemHandlerModifiable)this.inventory, (IFluidHandler)this.blockEntity.getFluidTank()), this.level);
    }

    public int m_6636_() {
        return 5;
    }

    public int m_6635_() {
        return 2;
    }

    public int m_6656_() {
        return 2;
    }

    public int m_6653_() {
        return 6;
    }

    public RecipeBookType m_5867_() {
        return BrewinAndChewin.FERMENTING;
    }

    public boolean m_142157_(int slot) {
        return slot < this.m_6635_() * this.m_6656_();
    }
}

