/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.data.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.brewinandchewin.client.recipebook.FermentingRecipeBookTab;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;

public class KegFermentingRecipeBuilder {
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private Optional<FluidStack> fluidIngredient = Optional.empty();
    private Optional<Fluid> resultFluid = Optional.empty();
    private Optional<Item> resultItem = Optional.empty();
    private Optional<FermentingRecipeBookTab> tab = Optional.empty();
    private final int fermentingTime;
    private final float experience;
    private final int temperature;
    private final int amount;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    private KegFermentingRecipeBuilder(int amount, int fermentingTime, float experience, int temperature) {
        this.fermentingTime = fermentingTime;
        this.experience = experience;
        this.temperature = temperature;
        this.amount = amount;
    }

    public static KegFermentingRecipeBuilder kegFermentingRecipe(Item item, int amount, int fermentingTime, float experience, int temperature) {
        KegFermentingRecipeBuilder i = new KegFermentingRecipeBuilder(amount, fermentingTime, experience, temperature);
        i.setResult(item);
        return i;
    }

    public static KegFermentingRecipeBuilder kegFermentingRecipe(Fluid fluid, int amount, int fermentingTime, float experience, int temperature) {
        KegFermentingRecipeBuilder i = new KegFermentingRecipeBuilder(amount, fermentingTime, experience, temperature);
        i.setResult(fluid);
        return i;
    }

    public static KegFermentingRecipeBuilder kegFermentingRecipe(Item item, int amount, int fermentingTime, float experience) {
        KegFermentingRecipeBuilder i = new KegFermentingRecipeBuilder(amount, fermentingTime, experience, 3);
        i.setResult(item);
        return i;
    }

    public static KegFermentingRecipeBuilder kegFermentingRecipe(Fluid fluid, int amount, int fermentingTime, float experience) {
        KegFermentingRecipeBuilder i = new KegFermentingRecipeBuilder(amount, fermentingTime, experience, 3);
        i.setResult(fluid);
        return i;
    }

    private void setResult(Fluid fluid) {
        this.resultFluid = Optional.of(fluid);
    }

    private void setResult(Item item) {
        this.resultItem = Optional.of(item);
    }

    public KegFermentingRecipeBuilder addIngredient(TagKey<Item> tagIn) {
        return this.addIngredient(Ingredient.m_204132_(tagIn));
    }

    public KegFermentingRecipeBuilder addIngredient(ItemLike itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public KegFermentingRecipeBuilder addIngredient(ItemLike itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
        }
        return this;
    }

    public KegFermentingRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public KegFermentingRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public KegFermentingRecipeBuilder setRecipeBookTab(FermentingRecipeBookTab tab) {
        this.tab = Optional.of(tab);
        return this;
    }

    public KegFermentingRecipeBuilder unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public KegFermentingRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items));
    }

    public KegFermentingRecipeBuilder unlockedByAnyIngredient(ItemLike ... items) {
        this.advancement.m_138386_("has_any_ingredient", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(items).m_45077_()}));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        if (!this.resultFluid.isPresent() && !this.resultItem.isPresent()) {
            throw new IllegalStateException("No result fluid or item");
        }
        if (this.resultItem.isPresent()) {
            ResourceLocation resultItemLocation = ForgeRegistries.ITEMS.getKey((Object)this.resultItem.get());
            this.build(consumerIn, "brewinandchewin:fermenting/" + resultItemLocation.m_135815_());
        } else if (!this.fluidIngredient.isPresent()) {
            ResourceLocation resultFluidLocation = ForgeRegistries.FLUIDS.getKey((Object)this.resultFluid.get());
            this.build(consumerIn, "brewinandchewin:fermenting/" + resultFluidLocation.m_135815_());
        } else {
            ResourceLocation baseFluidLocation = ForgeRegistries.FLUIDS.getKey((Object)this.fluidIngredient.get().getFluid());
            ResourceLocation resultFluidLocation = ForgeRegistries.FLUIDS.getKey((Object)this.resultFluid.get());
            this.build(consumerIn, "brewinandchewin:fermenting/" + resultFluidLocation.m_135815_() + "_from_" + baseFluidLocation.m_135815_());
        }
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation;
        if (!this.resultFluid.isPresent() && !this.resultItem.isPresent()) {
            throw new IllegalStateException("No result fluid or item");
        }
        ResourceLocation resourceLocation = resourcelocation = this.resultItem.isPresent() ? ForgeRegistries.ITEMS.getKey((Object)this.resultItem.get()) : ForgeRegistries.FLUIDS.getKey((Object)this.resultFluid.get());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Fermenting Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public KegFermentingRecipeBuilder addFluidIngredient(Fluid flowingFluid, int i) {
        this.fluidIngredient = Optional.of(new FluidStack(flowingFluid, i));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        ResourceLocation advancementId = null;
        if (!this.advancement.m_138405_().isEmpty()) {
            this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            advancementId = id.m_247266_(path -> "recipes/" + path);
        }
        consumerIn.accept(new Result(id, this.fluidIngredient, this.tab, this.resultItem, this.resultFluid, this.amount, this.ingredients, this.fermentingTime, this.experience, this.temperature, this.advancement, advancementId));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> ingredients;
        private final Optional<FermentingRecipeBookTab> tab;
        private final Optional<FluidStack> fluidIngredient;
        private final Optional<Item> resultItem;
        private final Optional<Fluid> resultFluid;
        private final int fermentingTime;
        private final float experience;
        private final int temperature;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation idIn, Optional<FluidStack> fluidIngredient, Optional<FermentingRecipeBookTab> tab, Optional<Item> resultItemIn, Optional<Fluid> resultFluidIn, int count, List<Ingredient> ingredientsIn, int fermentingTimeIn, float experienceIn, int temperatureIn, @Nullable Advancement.Builder advancement, @Nullable ResourceLocation advancementId) {
            this.id = idIn;
            this.fluidIngredient = fluidIngredient;
            this.tab = tab;
            this.resultItem = resultItemIn;
            this.resultFluid = resultFluidIn;
            this.count = count;
            this.ingredients = ingredientsIn;
            this.fermentingTime = fermentingTimeIn;
            this.experience = experienceIn;
            this.temperature = temperatureIn;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            JsonArray arrayIngredients = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                arrayIngredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)arrayIngredients);
            JsonObject result = new JsonObject();
            if (this.resultItem.isPresent()) {
                result.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.resultItem.get()).toString());
            } else {
                result.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.resultFluid.get()).toString());
            }
            result.addProperty("count", (Number)this.count);
            json.add("result", (JsonElement)result);
            if (this.fluidIngredient.isPresent()) {
                JsonObject basefluid = new JsonObject();
                basefluid.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluidIngredient.get().getFluid()).toString());
                basefluid.addProperty("count", (Number)this.fluidIngredient.get().getAmount());
                json.add("basefluid", (JsonElement)basefluid);
            }
            this.tab.ifPresent(t -> json.addProperty("recipe_book_tab", t.name));
            if (this.experience > 0.0f) {
                json.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
            json.addProperty("fermentingtime", (Number)this.fermentingTime);
            json.addProperty("temperature", (Number)this.temperature);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)BnCRecipeSerializers.FERMENTING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement != null ? this.advancement.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

