/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.recipe;

import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;

public class CookingRecipes {
    public static final int FAST_COOKING = 100;
    public static final int NORMAL_COOKING = 200;
    public static final int SLOW_COOKING = 400;
    public static final float SMALL_EXP = 0.35f;
    public static final float MEDIUM_EXP = 1.0f;
    public static final float LARGE_EXP = 2.0f;

    public static void register(Consumer<FinishedRecipe> consumer) {
        CookingRecipes.cookMiscellaneous(consumer);
        CookingRecipes.cookMinecraftSoups(consumer);
        CookingRecipes.cookMeals(consumer);
    }

    private static void cookMiscellaneous(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.HOT_COCOA.get(), 1, 200, 1.0f).addIngredient(ForgeTags.MILK).addIngredient((ItemLike)Items.f_42501_).addIngredient((ItemLike)Items.f_42533_).addIngredient((ItemLike)Items.f_42533_).unlockedByAnyIngredient(new ItemLike[]{Items.f_42533_, Items.f_42455_, (ItemLike)ModItems.MILK_BOTTLE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.APPLE_CIDER.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.f_42410_).addIngredient((ItemLike)Items.f_42410_).addIngredient((ItemLike)Items.f_42501_).unlockedByItems("has_apple", new ItemLike[]{Items.f_42410_}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.TOMATO_SAUCE.get(), 1, 100, 0.35f).addIngredient(ForgeTags.CROPS_TOMATO).addIngredient(ForgeTags.CROPS_TOMATO).unlockedByItems("has_tomato", (ItemLike)ModItems.TOMATO.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.DOG_FOOD.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.f_42583_).addIngredient((ItemLike)Items.f_42499_).addIngredient(ModTags.WOLF_PREY).addIngredient(ForgeTags.CROPS_RICE).unlockedByAnyIngredient(new ItemLike[]{Items.f_42583_, Items.f_42499_, (ItemLike)ModItems.RICE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.GLOW_BERRY_CUSTARD.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.f_151079_).addIngredient(ForgeTags.MILK).addIngredient(ForgeTags.EGGS).addIngredient((ItemLike)Items.f_42501_).unlockedByAnyIngredient(new ItemLike[]{Items.f_151079_, Items.f_42455_, (ItemLike)ModItems.MILK_BOTTLE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(consumer);
    }

    private static void cookMinecraftSoups(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.f_42400_, 1, 200, 1.0f, (ItemLike)Items.f_42399_).addIngredient((ItemLike)Items.f_41952_).addIngredient((ItemLike)Items.f_41953_).unlockedByAnyIngredient(new ItemLike[]{Blocks.f_50072_, Blocks.f_50073_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.f_42734_, 1, 200, 1.0f, (ItemLike)Items.f_42399_).addIngredient((ItemLike)Items.f_42732_).addIngredient((ItemLike)Items.f_42732_).addIngredient((ItemLike)Items.f_42732_).unlockedByItems("has_beetroot", new ItemLike[]{Items.f_42732_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.f_42699_, 1, 200, 1.0f, (ItemLike)Items.f_42399_).addIngredient((ItemLike)Items.f_42674_).addIngredient((ItemLike)Items.f_42697_).addIngredient((ItemLike)Items.f_42619_).addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41952_, Items.f_41953_})).unlockedByAnyIngredient(new ItemLike[]{Items.f_42697_, Items.f_41952_, Items.f_41953_, Items.f_42619_, Items.f_42674_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
    }

    private static void cookMeals(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.BAKED_COD_STEW.get(), 1, 200, 1.0f).addIngredient(ForgeTags.RAW_FISHES_COD).addIngredient((ItemLike)Items.f_42620_).addIngredient(ForgeTags.EGGS).addIngredient(ForgeTags.CROPS_TOMATO).unlockedByAnyIngredient(new ItemLike[]{Items.f_42526_, Items.f_42620_, (ItemLike)ModItems.TOMATO.get(), Items.f_42521_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.BEEF_STEW.get(), 1, 200, 1.0f).addIngredient(ForgeTags.RAW_BEEF).addIngredient((ItemLike)Items.f_42619_).addIngredient((ItemLike)Items.f_42620_).unlockedByAnyIngredient(new ItemLike[]{Items.f_42579_, Items.f_42619_, Items.f_42620_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.BONE_BROTH.get(), 1, 200, 0.35f).addIngredient((TagKey<Item>)Tags.Items.BONES).addIngredient(Ingredient.m_43938_(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_151079_)), new Ingredient.TagValue(Tags.Items.MUSHROOMS), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_151017_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_151025_))))).unlockedByItems("has_bone", new ItemLike[]{Items.f_42500_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.CABBAGE_ROLLS.get(), 1, 100, 0.35f).addIngredient(ForgeTags.CROPS_CABBAGE).addIngredient(ModTags.CABBAGE_ROLL_INGREDIENTS).unlockedByAnyIngredient((ItemLike)ModItems.CABBAGE.get(), (ItemLike)ModItems.CABBAGE_LEAF.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.CHICKEN_SOUP.get(), 1, 200, 1.0f).addIngredient(ForgeTags.RAW_CHICKEN).addIngredient((ItemLike)Items.f_42619_).addIngredient(ForgeTags.SALAD_INGREDIENTS).addIngredient(ForgeTags.VEGETABLES).unlockedByAnyIngredient(new ItemLike[]{Items.f_42581_, Items.f_42619_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.COOKED_RICE.get(), 1, 100, 0.35f).addIngredient(ForgeTags.CROPS_RICE).unlockedByItems("has_rice", (ItemLike)ModItems.RICE.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.DUMPLINGS.get(), 2, 200, 1.0f).addIngredient(ForgeTags.DOUGH).addIngredient(ForgeTags.CROPS_CABBAGE).addIngredient(ForgeTags.CROPS_ONION).addIngredient(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(ForgeTags.RAW_CHICKEN), new Ingredient.TagValue(ForgeTags.RAW_PORK), new Ingredient.TagValue(ForgeTags.RAW_BEEF), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41952_))))).unlockedByAnyIngredient((ItemLike)ModItems.WHEAT_DOUGH.get(), (ItemLike)ModItems.CABBAGE.get(), (ItemLike)ModItems.ONION.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.FISH_STEW.get(), 1, 200, 1.0f).addIngredient(ForgeTags.RAW_FISHES).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).addIngredient(ForgeTags.CROPS_ONION).unlockedByAnyIngredient(new ItemLike[]{Items.f_42527_, Items.f_42526_, Items.f_42528_, (ItemLike)ModItems.TOMATO_SAUCE.get(), (ItemLike)ModItems.ONION.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.FRIED_RICE.get(), 1, 200, 1.0f).addIngredient(ForgeTags.CROPS_RICE).addIngredient(ForgeTags.EGGS).addIngredient((ItemLike)Items.f_42619_).addIngredient(ForgeTags.CROPS_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RICE.get(), Items.f_42521_, Items.f_42619_, (ItemLike)ModItems.ONION.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.MUSHROOM_RICE.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.f_41952_).addIngredient((ItemLike)Items.f_41953_).addIngredient(ForgeTags.CROPS_RICE).addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42620_})).unlockedByAnyIngredient(new ItemLike[]{Blocks.f_50072_, Blocks.f_50073_, (ItemLike)ModItems.RICE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.NOODLE_SOUP.get(), 1, 200, 1.0f).addIngredient(ForgeTags.PASTA).addIngredient(ForgeTags.COOKED_EGGS).addIngredient((ItemLike)Items.f_42576_).addIngredient(ForgeTags.RAW_PORK).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.f_42576_, Items.f_42485_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PASTA_WITH_MEATBALLS.get(), 1, 200, 1.0f).addIngredient((ItemLike)ModItems.MINCED_BEEF.get()).addIngredient(ForgeTags.PASTA).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.f_42579_, (ItemLike)ModItems.TOMATO_SAUCE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PASTA_WITH_MUTTON_CHOP.get(), 1, 200, 1.0f).addIngredient(ForgeTags.RAW_MUTTON).addIngredient(ForgeTags.PASTA).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.f_42658_, (ItemLike)ModItems.TOMATO_SAUCE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PUMPKIN_SOUP.get(), 1, 200, 1.0f).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).addIngredient(ForgeTags.SALAD_INGREDIENTS).addIngredient(ForgeTags.RAW_PORK).addIngredient(ForgeTags.MILK).unlockedByAnyIngredient(new ItemLike[]{Items.f_42046_, (ItemLike)ModItems.PUMPKIN_SLICE.get(), Items.f_42485_, Items.f_42455_, (ItemLike)ModItems.MILK_BOTTLE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.RATATOUILLE.get(), 1, 200, 1.0f).addIngredient(ForgeTags.CROPS_TOMATO).addIngredient(ForgeTags.CROPS_ONION).addIngredient((ItemLike)Items.f_42732_).addIngredient(ForgeTags.VEGETABLES).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.TOMATO.get(), (ItemLike)ModItems.ONION.get(), Items.f_42732_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.SQUID_INK_PASTA.get(), 1, 200, 1.0f).addIngredient(ForgeTags.RAW_FISHES).addIngredient(ForgeTags.PASTA).addIngredient(ForgeTags.CROPS_TOMATO).addIngredient((ItemLike)Items.f_42532_).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.f_42532_, (ItemLike)ModItems.TOMATO.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.STUFFED_PUMPKIN_BLOCK.get(), 1, 400, 2.0f, (ItemLike)Items.f_42046_).addIngredient(ForgeTags.CROPS_RICE).addIngredient(ForgeTags.CROPS_ONION).addIngredient((ItemLike)Items.f_41952_).addIngredient((ItemLike)Items.f_42620_).addIngredient(ForgeTags.BERRIES).addIngredient(ForgeTags.VEGETABLES).unlockedByItems("has_pumpkin", new ItemLike[]{Blocks.f_50133_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.VEGETABLE_NOODLES.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.f_42619_).addIngredient((ItemLike)Items.f_41952_).addIngredient(ForgeTags.PASTA).addIngredient(ForgeTags.SALAD_INGREDIENTS).addIngredient(ForgeTags.VEGETABLES).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.f_41952_, Items.f_42619_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.VEGETABLE_SOUP.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.f_42619_).addIngredient((ItemLike)Items.f_42620_).addIngredient((ItemLike)Items.f_42732_).addIngredient(ForgeTags.SALAD_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{Items.f_42619_, (ItemLike)ModItems.ONION.get(), Items.f_42732_}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
    }
}

